/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.function.BiConsumer;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.QueueStorePrefetch;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.SystemUsage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StoreCursorRemoveFromCacheTest {
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder();
    private final ActiveMQQueue destination = new ActiveMQQueue("queue");
    private BrokerService broker;
    private SystemUsage systemUsage;
    private KahaDBStore store;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(true);
        KahaDBStore store = new KahaDBStore();
        store.setDirectory(this.dataFileDir.getRoot());
        this.broker.setPersistenceAdapter((PersistenceAdapter)store);
        this.broker.start();
        this.systemUsage = this.broker.getSystemUsage();
        this.store = (KahaDBStore)this.broker.getPersistenceAdapter();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test(timeout=10000L)
    public void testRemoveFromCacheIterator() throws Exception {
        this.testRemoveFromCache((cursor, ref) -> cursor.remove());
    }

    @Test(timeout=10000L)
    public void testRemoveFromCacheRemoveMethod() throws Exception {
        this.testRemoveFromCache((cursor, ref) -> {
            cursor.remove(ref);
            Assert.assertEquals((long)0L, (long)ref.getReferenceCount());
            cursor.remove(ref);
            Assert.assertEquals((long)0L, (long)ref.getReferenceCount());
        });
    }

    private void testRemoveFromCache(BiConsumer<QueueStorePrefetch, MessageReference> remove) throws Exception {
        SystemUsage systemUsage = this.broker.getSystemUsage();
        KahaDBStore store = (KahaDBStore)this.broker.getPersistenceAdapter();
        MessageStore messageStore = store.createQueueMessageStore(this.destination);
        Queue queue = new Queue(this.broker, (ActiveMQDestination)this.destination, messageStore, new DestinationStatistics(), null);
        MemoryUsage memoryUsage = queue.getMemoryUsage();
        QueueStorePrefetch cursor = new QueueStorePrefetch(queue, this.broker.getBroker());
        cursor.setSystemUsage(systemUsage);
        cursor.start();
        Assert.assertTrue((String)"cache enabled", (cursor.isUseCache() && cursor.isCacheEnabled() ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            ActiveMQTextMessage msg = this.getMessage(i);
            msg.setMemoryUsage(memoryUsage);
            cursor.addMessageLast((MessageReference)msg);
            Assert.assertEquals((long)1L, (long)msg.getReferenceCount());
        }
        Assert.assertTrue((memoryUsage.getUsage() > 0L ? 1 : 0) != 0);
        cursor.reset();
        while (cursor.hasNext()) {
            MessageReference ref = cursor.next();
            Assert.assertEquals((long)2L, (long)ref.getReferenceCount());
            ref.decrementReferenceCount();
            remove.accept(cursor, ref);
            Assert.assertEquals((long)0L, (long)ref.getReferenceCount());
        }
        Assert.assertEquals((long)0L, (long)memoryUsage.getUsage());
        Assert.assertEquals((long)0L, (long)cursor.size());
    }

    private ActiveMQTextMessage getMessage(int i) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        MessageId id = new MessageId("11111:22222:" + i);
        id.setBrokerSequenceId((long)i);
        id.setProducerSequenceId((long)i);
        message.setMessageId(id);
        message.setDestination((ActiveMQDestination)this.destination);
        message.setPersistent(true);
        message.setResponseRequired(true);
        message.setText("Msg:" + i + " test");
        Assert.assertEquals((long)message.getMessageId().getProducerSequenceId(), (long)i);
        return message;
    }
}

