/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.usage.SystemUsage;

public class StoreBasedCursorTest
extends TestCase {
    protected String bindAddress = "tcp://localhost:60706";
    BrokerService broker;
    ActiveMQConnectionFactory factory;
    Connection connection;
    Session session;
    Queue queue;
    int messageSize = 1024;
    int memoryLimit = 12 * this.messageSize;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.broker == null) {
            this.broker = new BrokerService();
            this.broker.setAdvisorySupport(false);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    protected void start() throws Exception {
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory("vm://localhost?jms.alwaysSyncSend=true");
        this.factory.setWatchTopicAdvisories(false);
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.queue = this.session.createQueue("QUEUE." + ((Object)((Object)this)).getClass().getName());
    }

    protected void stop() throws Exception {
        this.session.close();
        this.connection.close();
        this.broker.stop();
        this.broker = null;
    }

    protected void configureBroker(long memoryLimit, long systemLimit) throws Exception {
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector(this.bindAddress);
        this.broker.setPersistent(true);
        SystemUsage systemUsage = this.broker.getSystemUsage();
        systemUsage.setSendFailIfNoSpace(true);
        systemUsage.getMemoryUsage().setLimit(systemLimit);
        PolicyEntry policy = new PolicyEntry();
        policy.setProducerFlowControl(true);
        policy.setUseCache(true);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
    }

    protected String createMessageText(int index) {
        StringBuffer buffer = new StringBuffer(this.messageSize);
        buffer.append("Message: " + index + " sent at: " + String.valueOf(new Date()));
        if (buffer.length() > this.messageSize) {
            return buffer.substring(0, this.messageSize);
        }
        for (int i = buffer.length(); i < this.messageSize; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    protected void sendMessages(int deliveryMode) throws Exception {
        this.start();
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        producer.setDeliveryMode(deliveryMode);
        int i = 0;
        try {
            for (i = 0; i < 200; ++i) {
                TextMessage message = this.session.createTextMessage(this.createMessageText(i));
                producer.send((Message)message);
            }
        }
        catch (ResourceAllocationException e) {
            e.printStackTrace();
            StoreBasedCursorTest.fail((String)(e.getMessage() + " num msgs = " + i + ". percentUsage = " + this.broker.getSystemUsage().getMemoryUsage().getPercentUsage()));
        }
        this.stop();
    }

    public void testTwoUsageEqualPersistent() throws Exception {
        this.configureBroker(this.memoryLimit, this.memoryLimit);
        this.sendMessages(2);
    }

    public void testUseCachePersistent() throws Exception {
        int limit = this.memoryLimit / 2;
        this.configureBroker(limit, this.memoryLimit);
        this.sendMessages(2);
    }

    public void testMemoryUsageLowPersistent() throws Exception {
        this.configureBroker(this.memoryLimit, 10 * this.memoryLimit);
        this.sendMessages(2);
    }

    public void testTwoUsageEqualNonPersistent() throws Exception {
        this.configureBroker(this.memoryLimit, this.memoryLimit);
        this.sendMessages(1);
    }

    public void testMemoryUsageLowNonPersistent() throws Exception {
        this.configureBroker(this.memoryLimit, 10 * this.memoryLimit);
        this.sendMessages(1);
    }
}

