/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.ClientIdFilterDispatchPolicy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class ClientIdFilterDispatchPolicyTest {
    @Test
    public void testClientIdFilter() throws Exception {
        long time;
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false&useJmx=true"));
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy((DispatchPolicy)new ClientIdFilterDispatchPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        broker.start();
        String topic = "test.PTP";
        long timeout = 5000L;
        final Result r = new Result();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection1 = cf.createConnection();
        connection1.setClientID("test1");
        connection1.start();
        Session session1 = connection1.createSession(false, 1);
        MessageConsumer consumer1 = session1.createConsumer((Destination)new ActiveMQTopic(topic));
        consumer1.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    String clientId;
                    System.out.println(message.getStringProperty("PTP_CLIENTID"));
                    r.test1 = clientId = message.getStringProperty("PTP_CLIENTID");
                    ++r.count;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        Connection connection2 = cf.createConnection();
        connection2.setClientID("test2");
        connection2.start();
        Session session2 = connection2.createSession(false, 1);
        MessageConsumer consumer2 = session2.createConsumer((Destination)new ActiveMQTopic(topic));
        consumer2.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    String clientId;
                    System.out.println(message.getStringProperty("PTP_CLIENTID"));
                    r.test2 = clientId = message.getStringProperty("PTP_CLIENTID");
                    ++r.count;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        TextMessage m1 = session1.createTextMessage("test1");
        m1.setStringProperty("PTP_CLIENTID", "test1");
        TextMessage m2 = session1.createTextMessage("test2");
        m2.setStringProperty("PTP_CLIENTID", "test2");
        TextMessage m3 = session1.createTextMessage("test3");
        m3.setStringProperty("PTP_CLIENTID", "test3");
        MessageProducer producer = session1.createProducer((Destination)new ActiveMQTopic(topic));
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        for (time = 0L; r.count < 2 && time < timeout; time += 50L) {
            Thread.sleep(50L);
        }
        System.out.println(time);
        Assert.assertEquals((long)2L, (long)r.count);
        Assert.assertEquals((Object)"test1", (Object)r.test1);
        Assert.assertEquals((Object)"test2", (Object)r.test2);
        producer.close();
        session1.close();
        connection1.stop();
        session2.close();
        connection2.close();
        broker.stop();
    }

    public static class Result {
        int count;
        public String test1;
        public String test2;
    }
}

