/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.ConnectionFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.Log4JConfigViewMBean;
import org.apache.logging.log4j.LogManager;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JConfigTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(Log4JConfigTest.class);
    private static final String BROKER_LOGGER = "org.apache.activemq.broker.BrokerService";
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(true);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setUseJmx(true);
        answer.setSchedulerSupport(true);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    @Test
    public void testLog4JConfigViewExists() throws Exception {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        String log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName).toString();
        this.assertRegisteredObjectName(log4jConfigViewName);
    }

    @Test
    public void testLog4JConfigViewGetLoggers() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        List loggers = log4jConfigView.getLoggers();
        Log4JConfigTest.assertNotNull((Object)loggers);
        Log4JConfigTest.assertFalse((boolean)loggers.isEmpty());
    }

    @Test
    public void testLog4JConfigViewGetLevel() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        String level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertFalse((boolean)level.isEmpty());
    }

    @Test
    public void testLog4JConfigViewGetLevelUnknownLoggerName() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        String level = log4jConfigView.getLogLevel("not.a.logger");
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertFalse((boolean)level.isEmpty());
        Log4JConfigTest.assertEquals((String)LogManager.getRootLogger().getLevel().toString(), (String)level);
    }

    @Test
    public void testLog4JConfigViewSetLevel() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        String level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertFalse((boolean)level.isEmpty());
        log4jConfigView.setLogLevel(BROKER_LOGGER, "WARN");
        level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertEquals((String)"WARN", (String)level);
        log4jConfigView.setLogLevel(BROKER_LOGGER, "INFO");
        level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertEquals((String)"INFO", (String)level);
        List loggers = log4jConfigView.getLoggers();
        Log4JConfigTest.assertEquals((int)2, (int)loggers.size());
    }

    @Test
    public void testLog4JConfigViewSetLevelNoChangeIfLevelIsBad() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        log4jConfigView.setLogLevel(BROKER_LOGGER, "INFO");
        String level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertEquals((String)"INFO", (String)level);
        log4jConfigView.setLogLevel(BROKER_LOGGER, "BAD");
        level = log4jConfigView.getLogLevel(BROKER_LOGGER);
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertEquals((String)"INFO", (String)level);
    }

    @Test
    public void testLog4JConfigViewGetRootLogLevel() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        String level = log4jConfigView.getRootLogLevel();
        Log4JConfigTest.assertNotNull((Object)level);
        Log4JConfigTest.assertFalse((boolean)level.isEmpty());
        String currentRootLevel = LogManager.getRootLogger().getLevel().toString();
        Log4JConfigTest.assertEquals((String)currentRootLevel, (String)level);
    }

    @Test
    public void testLog4JConfigViewSetRootLevel() throws Throwable {
        String brokerObjectName = this.broker.getBrokerObjectName().toString();
        ObjectName log4jConfigViewName = BrokerMBeanSupport.createLog4JConfigViewName((String)brokerObjectName);
        Log4JConfigViewMBean log4jConfigView = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, log4jConfigViewName, Log4JConfigViewMBean.class, true);
        String currentRootLevel = LogManager.getRootLogger().getLevel().toString();
        log4jConfigView.setRootLogLevel("WARN");
        currentRootLevel = LogManager.getRootLogger().getLevel().toString();
        Log4JConfigTest.assertEquals((String)"WARN", (String)currentRootLevel);
        log4jConfigView.setRootLogLevel("INFO");
        currentRootLevel = LogManager.getRootLogger().getLevel().toString();
        Log4JConfigTest.assertEquals((String)"INFO", (String)currentRootLevel);
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            LOG.info("Bean Registered: " + String.valueOf(objectName));
        } else {
            Log4JConfigTest.fail((String)("Could not find MBean!: " + String.valueOf(objectName)));
        }
        return objectName;
    }
}

