/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.net.URI;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTestSupport;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;

public class mKahaDbQueueMasterSlaveTest
extends QueueMasterSlaveTestSupport {
    protected String MASTER_URL = "tcp://localhost:62001";
    protected String SLAVE_URL = "tcp://localhost:62002";

    @Override
    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("master");
        this.master.addConnector(this.MASTER_URL);
        this.master.setUseJmx(false);
        this.master.setPersistent(true);
        this.master.setDeleteAllMessagesOnStartup(true);
        MultiKahaDBPersistenceAdapter mKahaDB = new MultiKahaDBPersistenceAdapter();
        LinkedList<FilteredKahaDBPersistenceAdapter> adapters = new LinkedList<FilteredKahaDBPersistenceAdapter>();
        FilteredKahaDBPersistenceAdapter defaultEntry = new FilteredKahaDBPersistenceAdapter();
        defaultEntry.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
        defaultEntry.setPerDestination(true);
        adapters.add(defaultEntry);
        mKahaDB.setFilteredPersistenceAdapters(adapters);
        this.master.setPersistenceAdapter((PersistenceAdapter)mKahaDB);
        this.master.start();
    }

    @Override
    protected void createSlave() throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("slave");
                    TransportConnector connector = new TransportConnector();
                    connector.setUri(new URI(mKahaDbQueueMasterSlaveTest.this.SLAVE_URL));
                    broker.addConnector(connector);
                    broker.setUseJmx(false);
                    broker.setPersistent(true);
                    MultiKahaDBPersistenceAdapter mKahaDB = new MultiKahaDBPersistenceAdapter();
                    LinkedList<FilteredKahaDBPersistenceAdapter> adapters = new LinkedList<FilteredKahaDBPersistenceAdapter>();
                    FilteredKahaDBPersistenceAdapter defaultEntry = new FilteredKahaDBPersistenceAdapter();
                    defaultEntry.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
                    defaultEntry.setPerDestination(true);
                    adapters.add(defaultEntry);
                    mKahaDB.setFilteredPersistenceAdapters(adapters);
                    broker.setPersistenceAdapter((PersistenceAdapter)mKahaDB);
                    broker.start();
                    mKahaDbQueueMasterSlaveTest.this.slave.set(broker);
                    mKahaDbQueueMasterSlaveTest.this.slaveStarted.countDown();
                }
                catch (IllegalStateException broker) {
                }
                catch (Exception e) {
                    TestCase.fail((String)("failed to start slave broker, reason:" + String.valueOf(e)));
                }
            }
        };
        t.start();
    }
}

