/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.NioQueueSubscriptionTestListener;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class NioQueueSubscriptionTest
extends QueueSubscriptionTest {
    protected static final Logger LOG = LoggerFactory.getLogger(NioQueueSubscriptionTest.class);
    private final Map<Thread, Throwable> exceptions = Collections.synchronizedMap(new HashMap());

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("tcp://localhost:62621?trace=false");
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = BrokerFactory.createBroker((URI)new URI("broker://nio://localhost:62621?useQueueForAccept=false&persistent=false&wiewformat.maxInactivityDuration=0"));
        answer.getManagementContext().setCreateConnector(false);
        answer.setUseJmx(false);
        answer.setDeleteAllMessagesOnStartup(true);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setOptimizedDispatch(true);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        answer.setDestinationPolicy(policyMap);
        return answer;
    }

    @Ignore(value="See AMQ-4286")
    @Test(timeout=60000L)
    public void testLotsOfConcurrentConnections() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        final ConnectionFactory factory = this.createConnectionFactory();
        int connectionCount = 400;
        final AtomicInteger threadId = new AtomicInteger(0);
        for (int i = 0; i < connectionCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    int innerId = threadId.incrementAndGet();
                    try {
                        NioQueueSubscriptionTestListener listener = new NioQueueSubscriptionTestListener(innerId, NioQueueSubscriptionTest.this.exceptions, LOG);
                        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
                        connection.setExceptionListener((ExceptionListener)listener);
                        connection.start();
                        Assert.assertNotNull((Object)connection.getBrokerName());
                        NioQueueSubscriptionTest.this.connections.add(connection);
                    }
                    catch (Exception e) {
                        LOG.error(">>>> Exception in run() on thread " + innerId, (Throwable)e);
                        NioQueueSubscriptionTest.this.exceptions.put(Thread.currentThread(), e);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.exceptions.isEmpty()) {
            LOG.error(">>>> " + this.exceptions.size() + " exceptions like", this.exceptions.values().iterator().next());
            Assert.fail((String)("unexpected exceptions in worker threads: " + String.valueOf(this.exceptions.values().iterator().next())));
        }
        LOG.info("created " + connectionCount + " connections");
    }
}

