/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Test;

public class TopicSubscriptionCountBeforeFullTest
extends TestSupport {
    protected BrokerService brokerService;
    private Connection connection;
    private String brokerUrlString;
    private Session session;
    private Topic topic;
    private Destination amqDestination;
    private int prefetch = 10;

    protected void setUp() throws Exception {
        super.setUp();
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        TransportConnector tcp = this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        this.brokerUrlString = tcp.getPublishableConnectString();
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.topic = this.session.createTopic("test");
        this.session.createConsumer((jakarta.jms.Destination)this.topic);
        this.amqDestination = TestSupport.getDestination(this.brokerService, (ActiveMQDestination)new ActiveMQTopic("test"));
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUrlString);
        ActiveMQPrefetchPolicy prefecthPolicy = new ActiveMQPrefetchPolicy();
        prefecthPolicy.setTopicPrefetch(this.prefetch);
        factory.setPrefetchPolicy(prefecthPolicy);
        return factory;
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.brokerService.stop();
        super.tearDown();
    }

    @Test
    public void testCountBeforeFullPrefetchFilled() throws JMSException {
        this.sendMessages(10);
        TopicSubscriptionCountBeforeFullTest.assertEquals((int)this.getSubscription().countBeforeFull(), (int)0);
    }

    @Test
    public void testCountBeforeFullNotNull() throws JMSException {
        TopicSubscriptionCountBeforeFullTest.assertTrue((this.getSubscription().countBeforeFull() == this.prefetch ? 1 : 0) != 0);
    }

    protected void sendMessages(int count) throws JMSException {
        MessageProducer producer = this.session.createProducer((jakarta.jms.Destination)this.topic);
        for (int i = 0; i < count; ++i) {
            producer.send((Message)this.session.createTextMessage("testMessage"));
        }
    }

    protected Subscription getSubscription() {
        return (Subscription)this.amqDestination.getConsumers().get(0);
    }
}

