/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsSendReceiveTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    private static final Log LOG = LogFactory.getLog(JmsTopicSendReceiveWithTwoConnectionsTest.class);
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.sendConnection = this.createSendConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createReceiveConnection();
        this.receiveConnection.start();
        LOG.info((Object)("Created sendConnection: " + String.valueOf(this.sendConnection)));
        LOG.info((Object)("Created receiveConnection: " + String.valueOf(this.receiveConnection)));
        this.session = this.createSendSession(this.sendConnection);
        this.receiveSession = this.createReceiveSession(this.receiveConnection);
        LOG.info((Object)("Created sendSession: " + String.valueOf(this.session)));
        LOG.info((Object)("Created receiveSession: " + String.valueOf(this.receiveSession)));
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        LOG.info((Object)("Created producer: " + String.valueOf(this.producer) + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT")));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info((Object)("Created  consumer destination: " + String.valueOf(this.consumerDestination) + " of type: " + String.valueOf(this.consumerDestination.getClass())));
        LOG.info((Object)("Created  producer destination: " + String.valueOf(this.producerDestination) + " of type: " + String.valueOf(this.producerDestination.getClass())));
        this.consumer = this.createConsumer(this.receiveSession, this.consumerDestination);
        this.consumer.setMessageListener((MessageListener)this);
        LOG.info((Object)"Started connections");
    }

    protected Session createReceiveSession(Connection receiveConnection) throws Exception {
        return receiveConnection.createSession(false, 1);
    }

    protected Session createSendSession(Connection sendConnection) throws Exception {
        return sendConnection.createSession(false, 1);
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    protected MessageConsumer createConsumer(Session session, Destination dest) throws JMSException {
        return session.createConsumer(dest);
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }
}

