/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import org.apache.activemq.JmsSendReceiveTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTopicSendReceiveTest
extends JmsSendReceiveTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTopicSendReceiveTest.class);
    protected Connection connection;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        LOG.info("Created connection: " + String.valueOf(this.connection));
        this.session = this.connection.createSession(false, 1);
        LOG.info("Created session: " + String.valueOf(this.session));
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        LOG.info("Created producer: " + String.valueOf(this.producer) + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info("Created  consumer destination: " + String.valueOf(this.consumerDestination) + " of type: " + String.valueOf(this.consumerDestination.getClass()));
        LOG.info("Created  producer destination: " + String.valueOf(this.producerDestination) + " of type: " + String.valueOf(this.producerDestination.getClass()));
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            LOG.info("Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.session.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        LOG.info("Dumping stats...");
        LOG.info("Closing down connection");
        this.session.close();
        this.connection.close();
    }
}

