/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueCompositeSendReceiveTest
extends JmsTopicSendReceiveTest {
    private static final Log LOG = LogFactory.getLog(JmsQueueCompositeSendReceiveTest.class);

    @Override
    protected void setUp() throws Exception {
        this.topic = false;
        this.deliveryMode = 1;
        super.setUp();
    }

    @Override
    protected String getConsumerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    @Override
    protected String getProducerSubject() {
        return "FOO.BAR.HUMBUG,FOO.BAR.HUMBUG2";
    }

    @Override
    public void testSendReceive() throws Exception {
        super.testSendReceive();
        this.messages.clear();
        jakarta.jms.Queue consumerDestination = this.consumeSession.createQueue("FOO.BAR.HUMBUG2");
        LOG.info((Object)("Created  consumer destination: " + String.valueOf(consumerDestination) + " of type: " + String.valueOf(consumerDestination.getClass())));
        MessageConsumer consumer = null;
        if (this.durable) {
            LOG.info((Object)"Creating durable consumer");
            consumer = this.consumeSession.createDurableSubscriber((Topic)consumerDestination, this.getName());
        } else {
            consumer = this.consumeSession.createConsumer((Destination)consumerDestination);
        }
        consumer.setMessageListener((MessageListener)this);
        this.assertMessagesAreReceived();
        LOG.info((Object)(this.data.length + " messages(s) received, closing down connections"));
    }

    public void testDuplicate() throws Exception {
        ActiveMQDestination queue = (ActiveMQDestination)this.session.createQueue("TEST,TEST");
        for (int i = 0; i < this.data.length; ++i) {
            Message message = this.createMessage(i);
            this.configureMessage(message);
            if (this.verbose) {
                LOG.info((Object)("About to send a message: " + String.valueOf(message) + " with text: " + this.data[i]));
            }
            this.producer.send((Destination)queue, message);
        }
        Thread.sleep(200L);
        BrokerService broker = BrokerRegistry.getInstance().lookup("localhost");
        final Queue dest = (Queue)((RegionBroker)broker.getRegionBroker()).getQueueRegion().getDestinationMap().get(new ActiveMQQueue("TEST"));
        JmsQueueCompositeSendReceiveTest.assertTrue((String)"all messages were received", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return (long)JmsQueueCompositeSendReceiveTest.this.data.length == dest.getDestinationStatistics().getMessages().getCount();
            }
        }));
        dest.purge();
        JmsQueueCompositeSendReceiveTest.assertEquals((long)0L, (long)dest.getDestinationStatistics().getMessages().getCount());
    }
}

