/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExclusiveConsumerTest {
    private static final String VM_BROKER_URL = "vm://localhost";
    private BrokerService brokerService;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService = null;
        }
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExclusiveConsumerSelectedCreatedFirst() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE1?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE1");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE1");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExclusiveConsumerSelectedCreatedAfter() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE5");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE5?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE5");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFailoverToAnotherExclusiveConsumerCreatedFirst() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession1 = null;
        Session exclusiveSession2 = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession1 = conn.createSession(false, 1);
            exclusiveSession2 = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE2?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer1 = exclusiveSession1.createConsumer((Destination)exclusiveQueue);
            MessageConsumer exclusiveConsumer2 = exclusiveSession2.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE2");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE2");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer1.receive(100L));
            Assert.assertNull((Object)exclusiveConsumer2.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer1.close();
            producer.send((Message)msg);
            producer.send((Message)msg);
            Assert.assertNotNull((Object)exclusiveConsumer2.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFailoverToAnotherExclusiveConsumerCreatedAfter() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession1 = null;
        Session exclusiveSession2 = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession1 = conn.createSession(false, 1);
            exclusiveSession2 = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE6?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer1 = exclusiveSession1.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE6");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            MessageConsumer exclusiveConsumer2 = exclusiveSession2.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE6");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer1.receive(100L));
            Assert.assertNull((Object)exclusiveConsumer2.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer1.close();
            producer.send((Message)msg);
            producer.send((Message)msg);
            Assert.assertNotNull((Object)exclusiveConsumer2.receive(1000L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFailoverToNonExclusiveConsumer() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE3?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE3");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE3");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer.close();
            producer.send((Message)msg);
            Assert.assertNotNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFallbackToExclusiveConsumer() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session exclusiveSession = null;
        Session fallbackSession = null;
        Session senderSession = null;
        try {
            exclusiveSession = conn.createSession(false, 1);
            fallbackSession = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.QUEUE4?consumer.exclusive=true");
            MessageConsumer exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            ActiveMQQueue fallbackQueue = new ActiveMQQueue("TEST.QUEUE4");
            MessageConsumer fallbackConsumer = fallbackSession.createConsumer((Destination)fallbackQueue);
            ActiveMQQueue senderQueue = new ActiveMQQueue("TEST.QUEUE4");
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            producer.send((Message)msg);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer.close();
            producer.send((Message)msg);
            Assert.assertNotNull((Object)fallbackConsumer.receive(100L));
            exclusiveConsumer = exclusiveSession.createConsumer((Destination)exclusiveQueue);
            producer.send((Message)msg);
            Assert.assertNotNull((Object)exclusiveConsumer.receive(100L));
            Assert.assertNull((Object)fallbackConsumer.receive(100L));
        }
        finally {
            fallbackSession.close();
            senderSession.close();
            conn.close();
        }
    }
}

