/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.ActiveMQMessageAuditNoSync;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageAuditTest
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(ActiveMQMessageAuditTest.class);

    public ActiveMQMessageAuditTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIsDuplicateString() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        IdGenerator idGen = new IdGenerator();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String id = idGen.generateId();
            list.add(id);
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
        }
        List windowList = list.subList(list.size() - 1 - audit.getAuditDepth(), list.size() - 1);
        for (String id : windowList) {
            ActiveMQMessageAuditTest.assertTrue((String)("duplicate, id:" + id), (boolean)audit.isDuplicate(id));
        }
    }

    public void testIsDuplicateMessageReference() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>();
        for (int i = 0; i < count; ++i) {
            ProducerId pid = new ProducerId();
            pid.setConnectionId("test");
            pid.setSessionId(0L);
            pid.setValue(1L);
            MessageId id = new MessageId();
            id.setProducerId(pid);
            id.setProducerSequenceId((long)i);
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setMessageId(id);
            list.add(msg);
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(msg.getMessageId()));
        }
        List windowList = list.subList(list.size() - 1 - audit.getAuditDepth(), list.size() - 1);
        for (MessageReference msg : windowList) {
            ActiveMQMessageAuditTest.assertTrue((String)("duplicate msg:" + String.valueOf(msg)), (boolean)audit.isDuplicate(msg));
        }
    }

    public void testIsInOrderString() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        IdGenerator idGen = new IdGenerator();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String id = idGen.generateId();
            if (i == 0) {
                ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
                ActiveMQMessageAuditTest.assertTrue((boolean)audit.isInOrder(id));
            }
            if (i <= 1 || i % 2 == 0) continue;
            list.add(id);
        }
        for (String id : list) {
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isInOrder(id));
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
        }
    }

    public void testSerialization() throws Exception {
        ActiveMQMessageAuditNoSync audit = new ActiveMQMessageAuditNoSync();
        byte[] bytes = this.serialize(audit);
        LOG.debug("Length: " + bytes.length);
        audit = this.recover(bytes);
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>();
        for (int j = 0; j < 1000; ++j) {
            ProducerId pid = new ProducerId();
            pid.setConnectionId("test");
            pid.setSessionId(0L);
            pid.setValue((long)j);
            LOG.debug("producer " + j);
            for (int i = 0; i < 1000; ++i) {
                MessageId id = new MessageId();
                id.setProducerId(pid);
                id.setProducerSequenceId((long)i);
                ActiveMQMessage msg = new ActiveMQMessage();
                msg.setMessageId(id);
                list.add(msg);
                ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(msg.getMessageId().toString()));
                if (i % 100 == 0) {
                    bytes = this.serialize(audit);
                    LOG.debug("Length: " + bytes.length);
                    audit = this.recover(bytes);
                }
                if (i % 250 != 0) continue;
                for (MessageReference messageReference : list) {
                    audit.rollback(messageReference.getMessageId().toString());
                }
                list.clear();
                bytes = this.serialize(audit);
                LOG.debug("Length: " + bytes.length);
                audit = this.recover(bytes);
            }
        }
    }

    protected byte[] serialize(ActiveMQMessageAuditNoSync audit) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(audit);
        oout.flush();
        return baos.toByteArray();
    }

    protected ActiveMQMessageAuditNoSync recover(byte[] bytes) throws Exception {
        ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return (ActiveMQMessageAuditNoSync)objectIn.readObject();
    }
}

