/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.transport.Attach;
import org.apache.qpid.proton.amqp.transport.Begin;
import org.apache.qpid.proton.amqp.transport.Close;
import org.apache.qpid.proton.amqp.transport.Detach;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.End;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.amqp.transport.Open;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.ProtonJTransport;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Ssl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.TransportResult;
import org.apache.qpid.proton.engine.TransportResultFactory;
import org.apache.qpid.proton.engine.impl.AmqpHeader;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.FrameHandler;
import org.apache.qpid.proton.engine.impl.FrameParser;
import org.apache.qpid.proton.engine.impl.FrameWriter;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SaslImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLink;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportOutputAdaptor;
import org.apache.qpid.proton.engine.impl.TransportOutputWriter;
import org.apache.qpid.proton.engine.impl.TransportSender;
import org.apache.qpid.proton.engine.impl.TransportSession;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslImpl;
import org.apache.qpid.proton.framing.TransportFrame;

public class TransportImpl
extends EndpointImpl
implements ProtonJTransport,
FrameBody.FrameBodyHandler<Integer>,
FrameHandler,
TransportOutputWriter {
    private static final byte AMQP_FRAME_TYPE = 0;
    private FrameParser _frameParser;
    private ConnectionImpl _connectionEndpoint;
    private boolean _isOpenSent;
    private boolean _isCloseSent;
    private boolean _headerWritten;
    private TransportSession[] _remoteSessions;
    private TransportSession[] _localSessions;
    private TransportInput _inputProcessor;
    private TransportOutput _outputProcessor;
    private Map<SessionImpl, TransportSession> _transportSessionState = new HashMap<SessionImpl, TransportSession>();
    private Map<LinkImpl, TransportLink<?>> _transportLinkState = new HashMap();
    private DecoderImpl _decoder = new DecoderImpl();
    private EncoderImpl _encoder = new EncoderImpl(this._decoder);
    private int _maxFrameSize = -1;
    private int _remoteMaxFrameSize = 512;
    private final FrameWriter _frameWriter;
    private boolean _closeReceived;
    private Open _open;
    private SaslImpl _sasl;
    private SslImpl _ssl;
    private ProtocolTracer _protocolTracer = null;
    private ByteBuffer _lastInputBuffer;
    private TransportResult _lastTransportResult = TransportResultFactory.ok();
    private boolean _init;
    private FrameHandler _frameHandler = this;
    static String INCOMING = "<-";
    static String OUTGOING = "->";
    private static final boolean ENABLED = TransportImpl.getBooleanEnv("PN_TRACE_FRM");

    @Deprecated
    public TransportImpl() {
        this(-1);
    }

    TransportImpl(int maxFrameSize) {
        AMQPDefinedTypes.registerAllTypes(this._decoder, this._encoder);
        this._maxFrameSize = maxFrameSize;
        this._frameWriter = new FrameWriter(this._encoder, this._remoteMaxFrameSize, 0, this._protocolTracer, this);
    }

    private void init() {
        if (!this._init) {
            this._init = true;
            this._frameParser = new FrameParser(this._frameHandler, this._decoder, this._maxFrameSize);
            this._inputProcessor = this._frameParser;
            this._outputProcessor = new TransportOutputAdaptor(this, this._maxFrameSize);
        }
    }

    @Override
    public int getMaxFrameSize() {
        return this._maxFrameSize;
    }

    @Override
    public int getRemoteMaxFrameSize() {
        return this._remoteMaxFrameSize;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        if (this._init) {
            throw new IllegalStateException("Cannot set max frame size after transport has been initialised");
        }
        this._maxFrameSize = maxFrameSize;
    }

    @Override
    public void bind(Connection conn) {
        ((ConnectionImpl)conn).setBound(true);
        this._connectionEndpoint = (ConnectionImpl)conn;
        this._localSessions = new TransportSession[this._connectionEndpoint.getMaxChannels() + 1];
        this._remoteSessions = new TransportSession[this._connectionEndpoint.getMaxChannels() + 1];
        if (this.getRemoteState() != EndpointState.UNINITIALIZED) {
            this._connectionEndpoint.handleOpen(this._open);
            if (this.getRemoteState() == EndpointState.CLOSED) {
                this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
            }
            this._frameParser.flush();
        }
    }

    @Override
    public int input(byte[] bytes, int offset, int length) {
        this.oldApiCheckStateBeforeInput(length).checkIsOk();
        ByteBuffer inputBuffer = this.getInputBuffer();
        int numberOfBytesConsumed = ByteBufferUtils.pourArrayToBuffer(bytes, offset, length, inputBuffer);
        this.processInput().checkIsOk();
        return numberOfBytesConsumed;
    }

    public TransportResult oldApiCheckStateBeforeInput(int inputLength) {
        this._lastTransportResult.checkIsOk();
        if (inputLength == 0 && (this._connectionEndpoint == null || this._connectionEndpoint.getRemoteState() != EndpointState.CLOSED)) {
            return TransportResultFactory.error(new TransportException("Unexpected EOS when remote connection not closed: connection aborted"));
        }
        return TransportResultFactory.ok();
    }

    @Override
    public int output(byte[] bytes, int offset, int size2) {
        ByteBuffer outputBuffer = this.getOutputBuffer();
        int numberOfBytesOutput = ByteBufferUtils.pourBufferToArray(outputBuffer, bytes, offset, size2);
        this.outputConsumed();
        return numberOfBytesOutput;
    }

    @Override
    public boolean writeInto(ByteBuffer outputBuffer) {
        this.processHeader();
        this.processOpen();
        this.processBegin();
        this.processAttach();
        this.processReceiverFlow();
        this.processTransportWork();
        this.processTransportWork();
        this.processSenderFlow();
        this.processDetach();
        this.processEnd();
        this.processClose();
        this._frameWriter.readBytes(outputBuffer);
        return this._isCloseSent;
    }

    @Override
    public Sasl sasl() {
        if (this._sasl == null) {
            this.init();
            this._sasl = new SaslImpl(this._remoteMaxFrameSize);
            TransportWrapper transportWrapper = this._sasl.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
        }
        return this._sasl;
    }

    @Override
    public Ssl ssl(SslDomain sslDomain, SslPeerDetails sslPeerDetails) {
        if (this._ssl == null) {
            this.init();
            this._ssl = new SslImpl(sslDomain, sslPeerDetails);
            TransportWrapper transportWrapper = this._ssl.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
        }
        return this._ssl;
    }

    @Override
    public Ssl ssl(SslDomain sslDomain) {
        return this.ssl(sslDomain, null);
    }

    private void processDetach() {
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof LinkImpl)) continue;
                LinkImpl link2 = (LinkImpl)endpoint;
                TransportLink<?> transportLink = this.getTransportState(link2);
                SessionImpl session = link2.getSession();
                TransportSession transportSession = this.getTransportState(session);
                if (link2.getLocalState() != EndpointState.CLOSED || !transportLink.isLocalHandleSet() || this._isCloseSent || link2 instanceof SenderImpl && link2.getQueued() != 0 && !transportLink.detachReceived() && !transportSession.endReceived() && !this._closeReceived) continue;
                UnsignedInteger localHandle = transportLink.getLocalHandle();
                transportLink.clearLocalHandle();
                transportSession.freeLocalHandle(localHandle);
                Detach detach = new Detach();
                detach.setHandle(localHandle);
                detach.setClosed(true);
                ErrorCondition localError = link2.getCondition();
                if (localError.getCondition() != null) {
                    detach.setError(localError);
                }
                this.writeFrame(transportSession.getLocalChannel(), detach, null, null);
                endpoint.clearModified();
                link2.free();
            }
        }
    }

    private void writeFlow(TransportSession ssn, TransportLink link2) {
        Flow flow = new Flow();
        flow.setNextIncomingId(ssn.getNextIncomingId());
        flow.setNextOutgoingId(ssn.getNextOutgoingId());
        ssn.updateWindows();
        flow.setIncomingWindow(ssn.getIncomingWindowSize());
        flow.setOutgoingWindow(ssn.getOutgoingWindowSize());
        if (link2 != null) {
            flow.setHandle(link2.getLocalHandle());
            flow.setDeliveryCount(link2.getDeliveryCount());
            flow.setLinkCredit(link2.getLinkCredit());
            flow.setDrain(((LinkImpl)link2.getLink()).getDrain());
        }
        this.writeFrame(ssn.getLocalChannel(), flow, null, null);
    }

    private void processSenderFlow() {
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                SenderImpl sender;
                if (!(endpoint instanceof SenderImpl) || !(sender = (SenderImpl)endpoint).getDrain() || sender.getDrained() <= 0) continue;
                TransportSender transportLink = sender.getTransportLink();
                TransportSession transportSession = sender.getSession().getTransportSession();
                UnsignedInteger credits = transportLink.getLinkCredit();
                transportLink.setLinkCredit(UnsignedInteger.valueOf(0));
                transportLink.setDeliveryCount(transportLink.getDeliveryCount().add(credits));
                transportLink.setLinkCredit(UnsignedInteger.ZERO);
                sender.setDrained(0);
                this.writeFlow(transportSession, transportLink);
                endpoint.clearModified();
            }
        }
    }

    private void dumpQueue(String msg) {
        System.out.print("  " + msg + "{");
        for (DeliveryImpl dlv = this._connectionEndpoint.getTransportWorkHead(); dlv != null; dlv = dlv.getTransportWorkNext()) {
            System.out.print(new Binary(dlv.getTag()) + ", ");
        }
        System.out.println("}");
    }

    private void processTransportWork() {
        if (this._connectionEndpoint != null) {
            DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
            while (delivery != null) {
                LinkImpl link2 = delivery.getLink();
                if (link2 instanceof SenderImpl) {
                    if (this.processTransportWorkSender(delivery, (SenderImpl)link2)) {
                        delivery = delivery.clearTransportWork();
                        continue;
                    }
                    delivery = delivery.getTransportWorkNext();
                    continue;
                }
                if (this.processTransportWorkReceiver(delivery, (ReceiverImpl)link2)) {
                    delivery = delivery.clearTransportWork();
                    continue;
                }
                delivery = delivery.getTransportWorkNext();
            }
        }
    }

    private boolean processTransportWorkSender(DeliveryImpl delivery, SenderImpl snd) {
        TransportSender tpLink = snd.getTransportLink();
        SessionImpl session = snd.getSession();
        TransportSession tpSession = session.getTransportSession();
        boolean wasDone = delivery.isDone();
        if (!delivery.isDone() && (delivery.getDataLength() > 0 || delivery != snd.current()) && tpSession.hasOutgoingCredit() && tpLink.hasCredit()) {
            UnsignedInteger deliveryId = tpSession.getOutgoingDeliveryId();
            TransportDelivery tpDelivery = new TransportDelivery(deliveryId, delivery, tpLink);
            delivery.setTransportDelivery(tpDelivery);
            Transfer transfer = new Transfer();
            transfer.setDeliveryId(deliveryId);
            transfer.setDeliveryTag(new Binary(delivery.getTag()));
            transfer.setHandle(tpLink.getLocalHandle());
            if (delivery.isSettled()) {
                transfer.setSettled(Boolean.TRUE);
            } else {
                tpSession.addUnsettledOutgoing(deliveryId, delivery);
            }
            if (snd.current() == delivery) {
                transfer.setMore(true);
            }
            transfer.setMessageFormat(UnsignedInteger.ZERO);
            ByteBuffer payload = delivery.getData() == null ? null : ByteBuffer.wrap(delivery.getData(), delivery.getDataOffset(), delivery.getDataLength());
            this.writeFrame(tpSession.getLocalChannel(), transfer, payload, new PartialTransfer(transfer));
            tpSession.incrementOutgoingId();
            tpSession.decrementRemoteIncomingWindow();
            if (payload == null || !payload.hasRemaining()) {
                session.incrementOutgoingBytes(-delivery.pending());
                delivery.setData(null);
                delivery.setDataLength(0);
                if (!transfer.getMore()) {
                    delivery.setDone();
                    tpLink.setDeliveryCount(tpLink.getDeliveryCount().add(UnsignedInteger.ONE));
                    tpLink.setLinkCredit(tpLink.getLinkCredit().subtract(UnsignedInteger.ONE));
                    tpSession.incrementOutgoingDeliveryId();
                    session.incrementOutgoingDeliveries(-1);
                    snd.decrementQueued();
                }
            } else {
                int delta = delivery.getDataLength() - payload.remaining();
                delivery.setDataOffset(delivery.getDataOffset() + delta);
                delivery.setDataLength(payload.remaining());
                session.incrementOutgoingBytes(-delta);
            }
        }
        if (wasDone && delivery.getLocalState() != null) {
            TransportDelivery tpDelivery = delivery.getTransportDelivery();
            Disposition disposition = new Disposition();
            disposition.setFirst(tpDelivery.getDeliveryId());
            disposition.setLast(tpDelivery.getDeliveryId());
            disposition.setRole(Role.SENDER);
            disposition.setSettled(delivery.isSettled());
            if (delivery.isSettled()) {
                tpDelivery.settled();
            }
            disposition.setState(delivery.getLocalState());
            this.writeFrame(tpSession.getLocalChannel(), disposition, null, null);
        }
        return !delivery.isBuffered();
    }

    private boolean processTransportWorkReceiver(DeliveryImpl delivery, ReceiverImpl rcv) {
        TransportDelivery tpDelivery = delivery.getTransportDelivery();
        SessionImpl session = rcv.getSession();
        TransportSession tpSession = session.getTransportSession();
        Disposition disposition = new Disposition();
        disposition.setFirst(tpDelivery.getDeliveryId());
        disposition.setLast(tpDelivery.getDeliveryId());
        disposition.setRole(Role.RECEIVER);
        disposition.setSettled(delivery.isSettled());
        disposition.setState(delivery.getLocalState());
        this.writeFrame(tpSession.getLocalChannel(), disposition, null, null);
        if (delivery.isSettled()) {
            tpDelivery.settled();
        }
        return true;
    }

    private void processReceiverFlow() {
        if (this._connectionEndpoint != null) {
            EndpointImpl endpoint;
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                int credits;
                if (!(endpoint instanceof ReceiverImpl)) continue;
                ReceiverImpl receiver = (ReceiverImpl)endpoint;
                TransportLink<?> transportLink = this.getTransportState(receiver);
                TransportSession transportSession = this.getTransportState(receiver.getSession());
                if (receiver.getLocalState() != EndpointState.ACTIVE || (credits = receiver.clearUnsentCredits()) == 0 && !receiver.getDrain() && !transportSession.getIncomingWindowSize().equals(UnsignedInteger.ZERO)) continue;
                transportLink.addCredit(credits);
                this.writeFlow(transportSession, transportLink);
                if (receiver.getLocalState() != EndpointState.ACTIVE) continue;
                endpoint.clearModified();
            }
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() != EndpointState.ACTIVE || !transportSession.getIncomingWindowSize().equals(UnsignedInteger.ZERO)) continue;
                this.writeFlow(transportSession, null);
            }
        }
    }

    private void processAttach() {
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof LinkImpl)) continue;
                LinkImpl link2 = (LinkImpl)endpoint;
                TransportLink<?> transportLink = this.getTransportState(link2);
                if (link2.getLocalState() == EndpointState.UNINITIALIZED || transportLink.attachSent() || (link2.getRemoteState() != EndpointState.ACTIVE || transportLink.isLocalHandleSet()) && link2.getRemoteState() != EndpointState.UNINITIALIZED) continue;
                SessionImpl session = link2.getSession();
                TransportSession transportSession = this.getTransportState(session);
                UnsignedInteger localHandle = transportSession.allocateLocalHandle(transportLink);
                if (link2.getRemoteState() == EndpointState.UNINITIALIZED) {
                    transportSession.addHalfOpenLink(transportLink);
                }
                Attach attach = new Attach();
                attach.setHandle(localHandle);
                attach.setName(transportLink.getName());
                if (link2.getSenderSettleMode() != null) {
                    attach.setSndSettleMode(link2.getSenderSettleMode());
                }
                if (link2.getReceiverSettleMode() != null) {
                    attach.setRcvSettleMode(link2.getReceiverSettleMode());
                }
                if (link2.getSource() != null) {
                    attach.setSource(link2.getSource());
                }
                if (link2.getTarget() != null) {
                    attach.setTarget(link2.getTarget());
                }
                attach.setRole(endpoint instanceof ReceiverImpl ? Role.RECEIVER : Role.SENDER);
                if (link2 instanceof SenderImpl) {
                    attach.setInitialDeliveryCount(UnsignedInteger.ZERO);
                }
                this.writeFrame(transportSession.getLocalChannel(), attach, null, null);
                transportLink.sentAttach();
                if (link2.getLocalState() != EndpointState.ACTIVE || !(link2 instanceof SenderImpl) && link2.hasCredit()) continue;
                endpoint.clearModified();
            }
        }
    }

    private void processHeader() {
        if (!this._headerWritten) {
            this._frameWriter.writeHeader(AmqpHeader.HEADER);
            this._headerWritten = true;
        }
    }

    private void processOpen() {
        if (this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() != EndpointState.UNINITIALIZED && !this._isOpenSent) {
            Open open2 = new Open();
            open2.setContainerId(this._connectionEndpoint.getLocalContainerId());
            open2.setHostname(this._connectionEndpoint.getHostname());
            open2.setDesiredCapabilities(this._connectionEndpoint.getDesiredCapabilities());
            open2.setOfferedCapabilities(this._connectionEndpoint.getOfferedCapabilities());
            open2.setProperties(this._connectionEndpoint.getProperties());
            if (this._maxFrameSize > 0) {
                open2.setMaxFrameSize(UnsignedInteger.valueOf(this._maxFrameSize));
            }
            this._isOpenSent = true;
            this.writeFrame(0, open2, null, null);
        }
    }

    private void processBegin() {
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() == EndpointState.UNINITIALIZED || transportSession.beginSent()) continue;
                int channelId = this.allocateLocalChannel(transportSession);
                Begin begin = new Begin();
                if (session.getRemoteState() != EndpointState.UNINITIALIZED) {
                    begin.setRemoteChannel(UnsignedShort.valueOf((short)transportSession.getRemoteChannel()));
                }
                begin.setHandleMax(transportSession.getHandleMax());
                begin.setIncomingWindow(transportSession.getIncomingWindowSize());
                begin.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                begin.setNextOutgoingId(transportSession.getNextOutgoingId());
                this.writeFrame(channelId, begin, null, null);
                transportSession.sentBegin();
                if (session.getLocalState() != EndpointState.ACTIVE) continue;
                endpoint.clearModified();
            }
        }
    }

    private TransportSession getTransportState(SessionImpl session) {
        TransportSession transportSession = this._transportSessionState.get(session);
        if (transportSession == null) {
            transportSession = new TransportSession(this, session);
            session.setTransportSession(transportSession);
            this._transportSessionState.put(session, transportSession);
        }
        return transportSession;
    }

    private TransportLink<?> getTransportState(LinkImpl link2) {
        TransportLink<Object> transportLink = this._transportLinkState.get(link2);
        if (transportLink == null) {
            transportLink = TransportLink.createTransportLink(link2);
            this._transportLinkState.put(link2, transportLink);
        }
        return transportLink;
    }

    private int allocateLocalChannel(TransportSession transportSession) {
        for (int i = 0; i < this._localSessions.length; ++i) {
            if (this._localSessions[i] != null) continue;
            this._localSessions[i] = transportSession;
            transportSession.setLocalChannel(i);
            return i;
        }
        return -1;
    }

    private int freeLocalChannel(TransportSession transportSession) {
        int channel = transportSession.getLocalChannel();
        this._localSessions[channel] = null;
        transportSession.freeLocalChannel();
        return channel;
    }

    private void processEnd() {
        if (this._connectionEndpoint != null) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                TransportSession transportSession;
                SessionImpl session;
                if (!(endpoint instanceof SessionImpl) || (session = (SessionImpl)endpoint).getLocalState() != EndpointState.CLOSED || !(transportSession = session.getTransportSession()).isLocalChannelSet() || this.hasSendableMessages(session) || this._isCloseSent) continue;
                int channel = this.freeLocalChannel(transportSession);
                End end = new End();
                ErrorCondition localError = endpoint.getCondition();
                if (localError.getCondition() != null) {
                    end.setError(localError);
                }
                this.writeFrame(channel, end, null, null);
                endpoint.clearModified();
            }
        }
    }

    private boolean hasSendableMessages(SessionImpl session) {
        if (!(this._closeReceived || session != null && session.getTransportSession().endReceived())) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SenderImpl)) continue;
                SenderImpl sender = (SenderImpl)endpoint;
                if (session != null && sender.getSession() != session || sender.getQueued() == 0 || this.getTransportState(sender).detachReceived()) continue;
                return true;
            }
        }
        return false;
    }

    private void processClose() {
        if (this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() == EndpointState.CLOSED && !this._isCloseSent && !this.hasSendableMessages(null)) {
            Close close2 = new Close();
            ErrorCondition localError = this._connectionEndpoint.getCondition();
            if (localError.getCondition() != null) {
                close2.setError(localError);
            }
            this._isCloseSent = true;
            this.writeFrame(0, close2, null, null);
        }
    }

    private void writeFrame(int channel, FrameBody frameBody, ByteBuffer payload, Runnable onPayloadTooLarge) {
        this._frameWriter.writeFrame(channel, frameBody, payload, onPayloadTooLarge);
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._connectionEndpoint;
    }

    @Override
    public void free() {
        super.free();
    }

    @Override
    public void handleOpen(Open open2, Binary payload, Integer channel) {
        this.setRemoteState(EndpointState.ACTIVE);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.handleOpen(open2);
        } else {
            this._open = open2;
        }
        if (open2.getMaxFrameSize().longValue() > 0L) {
            this._remoteMaxFrameSize = (int)open2.getMaxFrameSize().longValue();
            this._frameWriter.setMaxFrameSize(this._remoteMaxFrameSize);
        }
    }

    @Override
    public void handleBegin(Begin begin, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession == null) {
            SessionImpl session;
            if (begin.getRemoteChannel() == null) {
                session = this._connectionEndpoint.session();
                transportSession = this.getTransportState(session);
            } else {
                transportSession = this._localSessions[begin.getRemoteChannel().intValue()];
                session = transportSession.getSession();
            }
            transportSession.setRemoteChannel(channel);
            session.setRemoteState(EndpointState.ACTIVE);
            transportSession.setNextIncomingId(begin.getNextOutgoingId());
            this._remoteSessions[channel.intValue()] = transportSession;
        }
    }

    @Override
    public void handleAttach(Attach attach, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            SessionImpl session = transportSession.getSession();
            TransportLink transportLink = transportSession.getLinkFromRemoteHandle(attach.getHandle());
            LinkImpl link2 = null;
            if (transportLink == null) {
                transportLink = transportSession.resolveHalfOpenLink(attach.getName());
                if (transportLink == null) {
                    link2 = attach.getRole() == Role.RECEIVER ? session.sender(attach.getName()) : session.receiver(attach.getName());
                    transportLink = this.getTransportState(link2);
                } else {
                    link2 = (LinkImpl)transportLink.getLink();
                }
                if (attach.getRole() == Role.SENDER) {
                    transportLink.setDeliveryCount(attach.getInitialDeliveryCount());
                }
                link2.setRemoteState(EndpointState.ACTIVE);
                link2.setRemoteSource(attach.getSource());
                link2.setRemoteTarget(attach.getTarget());
                link2.setRemoteReceiverSettleMode(attach.getRcvSettleMode());
                link2.setRemoteSenderSettleMode(attach.getSndSettleMode());
                transportLink.setName(attach.getName());
                transportLink.setRemoteHandle(attach.getHandle());
                transportSession.addLinkRemoteHandle(transportLink, attach.getHandle());
            }
        }
    }

    @Override
    public void handleFlow(Flow flow, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleFlow(flow);
        }
    }

    @Override
    public void handleTransfer(Transfer transfer, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleTransfer(transfer, payload);
        }
    }

    @Override
    public void handleDisposition(Disposition disposition, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            transportSession.handleDisposition(disposition);
        }
    }

    @Override
    public void handleDetach(Detach detach, Binary payload, Integer channel) {
        TransportLink transportLink;
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null && (transportLink = transportSession.getLinkFromRemoteHandle(detach.getHandle())) != null) {
            Object link2 = transportLink.getLink();
            transportLink.receivedDetach();
            transportSession.freeRemoteHandle(transportLink.getRemoteHandle());
            ((EndpointImpl)link2).setRemoteState(EndpointState.CLOSED);
            if (detach.getError() != null) {
                ((EndpointImpl)link2).getRemoteCondition().copyFrom(detach.getError());
            }
        }
    }

    @Override
    public void handleEnd(End end, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions[channel];
        if (transportSession != null) {
            this._remoteSessions[channel.intValue()] = null;
            transportSession.receivedEnd();
            SessionImpl session = transportSession.getSession();
            session.setRemoteState(EndpointState.CLOSED);
            ErrorCondition errorCondition = end.getError();
            if (errorCondition != null) {
                session.getRemoteCondition().copyFrom(errorCondition);
            }
        }
    }

    @Override
    public void handleClose(Close close2, Binary payload, Integer channel) {
        this._closeReceived = true;
        this.setRemoteState(EndpointState.CLOSED);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
            if (close2.getError() != null) {
                this._connectionEndpoint.getRemoteCondition().copyFrom(close2.getError());
            }
        }
    }

    @Override
    public boolean handleFrame(TransportFrame frame) {
        if (!this.isHandlingFrames()) {
            throw new IllegalStateException("Transport cannot accept frame: " + frame);
        }
        TransportImpl.log(this, INCOMING, frame);
        if (this._protocolTracer != null) {
            this._protocolTracer.receivedFrame(frame);
        }
        frame.getBody().invoke(this, frame.getPayload(), frame.getChannel());
        return this._closeReceived;
    }

    @Override
    public void closed() {
        if (!this._closeReceived) {
            throw new TransportException("connection aborted");
        }
    }

    @Override
    public boolean isHandlingFrames() {
        return this._connectionEndpoint != null || this.getRemoteState() == EndpointState.UNINITIALIZED;
    }

    @Override
    public ProtocolTracer getProtocolTracer() {
        return this._protocolTracer;
    }

    @Override
    public void setProtocolTracer(ProtocolTracer protocolTracer) {
        this._protocolTracer = protocolTracer;
    }

    @Override
    public ByteBuffer getInputBuffer() {
        return this.tail();
    }

    @Override
    public TransportResult processInput() {
        try {
            this.process();
            return TransportResultFactory.ok();
        }
        catch (TransportException e) {
            return TransportResultFactory.error(e);
        }
    }

    @Override
    public ByteBuffer getOutputBuffer() {
        this.pending();
        return this.head();
    }

    @Override
    public void outputConsumed() {
        this.pop(this._outputProcessor.head().position());
    }

    @Override
    public int capacity() {
        this.init();
        return this._inputProcessor.capacity();
    }

    @Override
    public ByteBuffer tail() {
        this.init();
        return this._inputProcessor.tail();
    }

    @Override
    public void process() throws TransportException {
        this.init();
        this._inputProcessor.process();
    }

    @Override
    public void close_tail() {
        this.init();
        this._inputProcessor.close_tail();
    }

    @Override
    public int pending() {
        this.init();
        return this._outputProcessor.pending();
    }

    @Override
    public ByteBuffer head() {
        this.init();
        return this._outputProcessor.head();
    }

    @Override
    public void pop(int bytes) {
        this.init();
        this._outputProcessor.pop(bytes);
    }

    @Override
    public void close_head() {
        this._outputProcessor.close_head();
    }

    @Override
    public String toString() {
        return "TransportImpl [_connectionEndpoint=" + this._connectionEndpoint + ", " + super.toString() + "]";
    }

    public void setFrameHandler(FrameHandler frameHandler) {
        this._frameHandler = frameHandler;
    }

    private static final boolean getBooleanEnv(String name) {
        String value = System.getenv(name);
        return "true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value);
    }

    static void log(Object ctx, String event, TransportFrame frame) {
        if (ENABLED) {
            StringBuilder msg = new StringBuilder();
            msg.append("[").append(System.identityHashCode(ctx)).append(":").append(frame.getChannel()).append("]");
            msg.append(" ").append(event).append(" ").append(frame.getBody());
            if (frame.getPayload() != null) {
                String payload = frame.getPayload().toString();
                if (payload.length() > 80) {
                    payload = payload.substring(0, 80) + "(" + payload.length() + ")";
                }
                msg.append(" \"").append(payload).append("\"");
            }
            System.out.println(msg.toString());
        }
    }

    private static class PartialTransfer
    implements Runnable {
        private final Transfer _transfer;

        public PartialTransfer(Transfer transfer) {
            this._transfer = transfer;
        }

        @Override
        public void run() {
            this._transfer.setMore(true);
        }
    }
}

