/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.ra.ActiveMQManagedConnection;
import org.apache.activemq.ra.ManagedSessionProxy;
import org.apache.activemq.ra.ManagedTransactionContext;

public class ManagedConnectionProxy
implements Connection,
QueueConnection,
TopicConnection,
ExceptionListener {
    private ActiveMQManagedConnection managedConnection;
    private final List<ManagedSessionProxy> sessions = new ArrayList<ManagedSessionProxy>();
    private ExceptionListener exceptionListener;

    public ManagedConnectionProxy(ActiveMQManagedConnection managedConnection) {
        this.managedConnection = managedConnection;
    }

    public void close() throws JMSException {
        if (this.managedConnection != null) {
            this.managedConnection.proxyClosedEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.exceptionListener = null;
        this.managedConnection = null;
        List<ManagedSessionProxy> list = this.sessions;
        synchronized (list) {
            for (ManagedSessionProxy p : this.sessions) {
                try {
                    p.cleanup();
                }
                catch (JMSException ignore) {}
            }
            this.sessions.clear();
        }
    }

    private Connection getConnection() throws JMSException {
        if (this.managedConnection == null) {
            throw new IllegalStateException("The Connection is closed");
        }
        return this.managedConnection.getPhysicalConnection();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionProxy(transacted, acknowledgeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedSessionProxy createSessionProxy(boolean transacted, int acknowledgeMode) throws JMSException {
        if (!transacted && acknowledgeMode == 0) {
            acknowledgeMode = 1;
        }
        ActiveMQSession session = (ActiveMQSession)this.getConnection().createSession(transacted, acknowledgeMode);
        ManagedTransactionContext txContext = new ManagedTransactionContext(this.managedConnection.getTransactionContext());
        session.setTransactionContext(txContext);
        ManagedSessionProxy p = new ManagedSessionProxy(session, this);
        p.setUseSharedTxContext(this.managedConnection.isInManagedTx());
        List<ManagedSessionProxy> list = this.sessions;
        synchronized (list) {
            this.sessions.add(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionClosed(ManagedSessionProxy session) {
        List<ManagedSessionProxy> list = this.sessions;
        synchronized (list) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseSharedTxContext(boolean enable) throws JMSException {
        List<ManagedSessionProxy> list = this.sessions;
        synchronized (list) {
            for (ManagedSessionProxy p : this.sessions) {
                p.setUseSharedTxContext(enable);
            }
        }
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession(this.createSessionProxy(transacted, acknowledgeMode));
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession(this.createSessionProxy(transacted, acknowledgeMode));
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setClientID(String clientID) throws JMSException {
        this.getConnection().setClientID(clientID);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getConnection();
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.getConnection().start();
    }

    public void stop() throws JMSException {
        this.getConnection().stop();
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue2, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("Not Supported.");
    }

    public ActiveMQManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    public void onException(JMSException e) {
        if (this.exceptionListener != null && this.managedConnection != null) {
            try {
                this.exceptionListener.onException(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

