/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.util.HashMap;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.URISupport;

public final class NetworkBridgeFactory {
    private NetworkBridgeFactory() {
    }

    public static DemandForwardingBridge createBridge(NetworkBridgeConfiguration config, Transport localTransport, Transport remoteTransport) {
        return NetworkBridgeFactory.createBridge(config, localTransport, remoteTransport, null);
    }

    public static DemandForwardingBridge createBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
        DemandForwardingBridge result = null;
        result = configuration.isConduitSubscriptions() ? new DurableConduitBridge(configuration, localTransport, remoteTransport) : new DemandForwardingBridge(configuration, localTransport, remoteTransport);
        if (listener != null) {
            result.setNetworkBridgeListener(listener);
        }
        return result;
    }

    public static Transport createLocalTransport(Broker broker) throws Exception {
        URI uri = broker.getVmConnectorURI();
        HashMap<String, String> map2 = new HashMap<String, String>(URISupport.parseParameters(uri));
        map2.put("network", "true");
        map2.put("async", "true");
        uri = URISupport.createURIWithQuery(uri, URISupport.createQueryString(map2));
        return TransportFactory.connect(uri);
    }
}

