/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.table.BlockIterator;
import org.iq80.leveldb.table.Footer;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.TableIterator;
import org.iq80.leveldb.util.VariableLengthQuantity;

public abstract class Table
implements SeekingIterable<Slice, Slice> {
    protected final String name;
    protected final FileChannel fileChannel;
    protected final Comparator<Slice> comparator;
    protected final boolean verifyChecksums;
    protected final Block indexBlock;
    protected final BlockHandle metaindexBlockHandle;
    protected static ByteBuffer uncompressedScratch = ByteBuffer.allocateDirect(0x400000);

    public Table(String name, FileChannel fileChannel, Comparator<Slice> comparator, boolean verifyChecksums) throws IOException {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)fileChannel, (Object)"fileChannel is null");
        long size2 = fileChannel.size();
        Preconditions.checkArgument((size2 >= 48L ? 1 : 0) != 0, (String)"File is corrupt: size must be at least %s bytes", (Object[])new Object[]{48});
        Preconditions.checkArgument((size2 <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"File must be smaller than %s bytes", (Object[])new Object[]{Integer.MAX_VALUE});
        Preconditions.checkNotNull(comparator, (Object)"comparator is null");
        this.name = name;
        this.fileChannel = fileChannel;
        this.verifyChecksums = verifyChecksums;
        this.comparator = comparator;
        Footer footer = this.init();
        this.indexBlock = this.readBlock(footer.getIndexBlockHandle());
        this.metaindexBlockHandle = footer.getMetaindexBlockHandle();
    }

    protected abstract Footer init() throws IOException;

    public TableIterator iterator() {
        return new TableIterator(this, this.indexBlock.iterator());
    }

    public Block openBlock(Slice blockEntry) {
        Block dataBlock;
        BlockHandle blockHandle = BlockHandle.readBlockHandle(blockEntry.input());
        try {
            dataBlock = this.readBlock(blockHandle);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return dataBlock;
    }

    protected abstract Block readBlock(BlockHandle var1) throws IOException;

    protected int uncompressedLength(ByteBuffer data) throws IOException {
        int length = VariableLengthQuantity.readVariableLengthInt(data.duplicate());
        return length;
    }

    public long getApproximateOffsetOf(Slice key) {
        BlockIterator iterator = this.indexBlock.iterator();
        iterator.seek(key);
        if (iterator.hasNext()) {
            BlockHandle blockHandle = BlockHandle.readBlockHandle(iterator.next().getValue().input());
            return blockHandle.getOffset();
        }
        return this.metaindexBlockHandle.getOffset();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", comparator=").append(this.comparator);
        sb.append(", verifyChecksums=").append(this.verifyChecksums);
        sb.append('}');
        return sb.toString();
    }

    public Callable<?> closer() {
        return new Closer(this.fileChannel);
    }

    private static class Closer
    implements Callable<Void> {
        private final Closeable closeable;

        public Closer(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public Void call() {
            Closeables.closeQuietly((Closeable)this.closeable);
            return null;
        }
    }
}

