/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.JaasCertificateCallbackHandler;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.activemq.security.JaasAuthenticationBroker;
import org.apache.activemq.security.JaasCertificateSecurityContext;

public class JaasCertificateAuthenticationBroker
extends BrokerFilter {
    private final String jaasConfiguration;

    public JaasCertificateAuthenticationBroker(Broker next, String jaasConfiguration) {
        super(next);
        this.jaasConfiguration = jaasConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info2) throws Exception {
        if (context.getSecurityContext() == null) {
            if (!(info2.getTransportContext() instanceof X509Certificate[])) {
                throw new SecurityException("Unable to authenticate transport without SSL certificate.");
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                try {
                    JaasCertificateCallbackHandler callback2 = new JaasCertificateCallbackHandler((X509Certificate[])info2.getTransportContext());
                    LoginContext lc = new LoginContext(this.jaasConfiguration, callback2);
                    lc.login();
                    Subject subject = lc.getSubject();
                    String dnName = "";
                    for (Principal principal : subject.getPrincipals()) {
                        if (!(principal instanceof UserPrincipal)) continue;
                        dnName = ((UserPrincipal)principal).getName();
                        break;
                    }
                    JaasCertificateSecurityContext s = new JaasCertificateSecurityContext(dnName, subject, (X509Certificate[])info2.getTransportContext());
                    context.setSecurityContext(s);
                }
                catch (Exception e) {
                    throw new SecurityException("User name [" + info2.getUserName() + "] or password is invalid. " + e.getMessage(), e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info2);
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info2, Throwable error2) throws Exception {
        super.removeConnection(context, info2, error2);
        context.setSecurityContext(null);
    }
}

