/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.protobuf.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.activemq.protobuf.WireFormat;
import org.apache.activemq.protobuf.compiler.CommandLineSupport;
import org.apache.activemq.protobuf.compiler.CompilerException;
import org.apache.activemq.protobuf.compiler.EnumDescriptor;
import org.apache.activemq.protobuf.compiler.EnumFieldDescriptor;
import org.apache.activemq.protobuf.compiler.FieldDescriptor;
import org.apache.activemq.protobuf.compiler.MessageDescriptor;
import org.apache.activemq.protobuf.compiler.OptionDescriptor;
import org.apache.activemq.protobuf.compiler.ProtoDescriptor;
import org.apache.activemq.protobuf.compiler.TextFormat;
import org.apache.activemq.protobuf.compiler.TypeDescriptor;
import org.apache.activemq.protobuf.compiler.parser.ParseException;
import org.apache.activemq.protobuf.compiler.parser.ProtoParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerator {
    private File out = new File(".");
    private File[] path = new File[]{new File(".")};
    private ProtoDescriptor proto;
    private String javaPackage;
    private String outerClassName;
    private PrintWriter w;
    private int indent;
    private ArrayList<String> errors = new ArrayList();
    private boolean multipleFiles;
    private boolean deferredDecode;
    private boolean auto_clear_optional_fields;
    static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void main(String[] args) {
        JavaGenerator generator = new JavaGenerator();
        if ((args = CommandLineSupport.setOptions(generator, args)).length == 0) {
            System.out.println("No proto files specified.");
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                System.out.println("Compiling: " + args[i]);
                generator.compile(new File(args[i]));
                continue;
            }
            catch (CompilerException e) {
                System.out.println("Protocol Buffer Compiler failed with the following error(s):");
                for (String error2 : e.getErrors()) {
                    System.out.println("");
                    System.out.println(error2);
                }
                System.out.println("");
                System.out.println("Compile failed.  For more details see error messages listed above.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(File file) throws CompilerException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ProtoParser parser = new ProtoParser(is);
            this.proto = parser.ProtoDescriptor();
            this.proto.setName(file.getName());
            this.loadImports(this.proto, file.getParentFile());
            this.proto.validate(this.errors);
        }
        catch (FileNotFoundException e) {
            this.errors.add("Failed to open: " + file.getPath() + ":" + e.getMessage());
        }
        catch (ParseException e) {
            this.errors.add("Failed to parse: " + file.getPath() + ":" + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable ignore) {}
        }
        if (!this.errors.isEmpty()) {
            throw new CompilerException(this.errors);
        }
        this.javaPackage = this.javaPackage(this.proto);
        this.outerClassName = this.javaClassName(this.proto);
        this.multipleFiles = this.isMultipleFilesEnabled(this.proto);
        this.deferredDecode = Boolean.parseBoolean(this.getOption(this.proto.getOptions(), "deferred_decode", "false"));
        this.auto_clear_optional_fields = Boolean.parseBoolean(this.getOption(this.proto.getOptions(), "auto_clear_optional_fields", "false"));
        if (this.multipleFiles) {
            this.generateProtoFile();
        } else {
            this.writeFile(this.outerClassName, new Closure(){

                public void execute() throws CompilerException {
                    JavaGenerator.this.generateProtoFile();
                }
            });
        }
        if (!this.errors.isEmpty()) {
            throw new CompilerException(this.errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String className, Closure closure) throws CompilerException {
        PrintWriter oldWriter = this.w;
        File outputFile = this.out;
        if (this.javaPackage != null) {
            String packagePath = this.javaPackage.replace('.', '/');
            outputFile = new File(outputFile, packagePath);
        }
        outputFile = new File(outputFile, className + ".java");
        outputFile.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            this.w = new PrintWriter(fos);
            closure.execute();
            this.w.flush();
        }
        catch (FileNotFoundException e) {
            this.errors.add("Failed to write to: " + outputFile.getPath() + ":" + e.getMessage());
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable ignore) {}
            this.w = oldWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImports(ProtoDescriptor proto, File protoDir) {
        LinkedHashMap<String, ProtoDescriptor> children = new LinkedHashMap<String, ProtoDescriptor>();
        for (String imp : proto.getImports()) {
            File file = new File(protoDir, imp);
            for (int i = 0; i < this.path.length && !file.exists(); ++i) {
                file = new File(this.path[i], imp);
            }
            if (!file.exists()) {
                this.errors.add("Cannot load import: " + imp);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                ProtoParser parser = new ProtoParser(is);
                ProtoDescriptor child = parser.ProtoDescriptor();
                child.setName(file.getName());
                this.loadImports(child, file.getParentFile());
                children.put(imp, child);
            }
            catch (ParseException e) {
                this.errors.add("Failed to parse: " + file.getPath() + ":" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                this.errors.add("Failed to open: " + file.getPath() + ":" + e.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable ignore) {}
            }
        }
        proto.setImportProtoDescriptors(children);
    }

    private void generateProtoFile() throws CompilerException {
        if (this.multipleFiles) {
            String className;
            EnumDescriptor o;
            TypeDescriptor value;
            Iterator<TypeDescriptor> i$ = this.proto.getEnums().values().iterator();
            while (i$.hasNext()) {
                o = value = i$.next();
                className = JavaGenerator.uCamel(o.getName());
                this.writeFile(className, new Closure(){

                    public void execute() throws CompilerException {
                        JavaGenerator.this.generateFileHeader();
                        JavaGenerator.this.generateEnum(o);
                    }
                });
            }
            i$ = this.proto.getMessages().values().iterator();
            while (i$.hasNext()) {
                o = value = (MessageDescriptor)i$.next();
                className = JavaGenerator.uCamel(((MessageDescriptor)((Object)o)).getName());
                this.writeFile(className, new Closure((MessageDescriptor)((Object)o)){
                    final /* synthetic */ MessageDescriptor val$o;
                    {
                        this.val$o = messageDescriptor;
                    }

                    public void execute() throws CompilerException {
                        JavaGenerator.this.generateFileHeader();
                        JavaGenerator.this.generateMessageBean(this.val$o);
                    }
                });
            }
        } else {
            this.generateFileHeader();
            this.p("public class " + this.outerClassName + " {");
            this.indent();
            for (EnumDescriptor enumType : this.proto.getEnums().values()) {
                this.generateEnum(enumType);
            }
            for (MessageDescriptor m : this.proto.getMessages().values()) {
                this.generateMessageBean(m);
            }
            this.unindent();
            this.p("}");
        }
    }

    private void generateFileHeader() {
        this.p("//");
        this.p("// Generated by protoc, do not edit by hand.");
        this.p("//");
        if (this.javaPackage != null) {
            this.p("package " + this.javaPackage + ";");
            this.p("");
        }
    }

    private void generateMessageBean(MessageDescriptor m) {
        String className = JavaGenerator.uCamel(m.getName());
        this.p();
        String staticOption = "static ";
        if (this.multipleFiles && m.getParent() == null) {
            staticOption = "";
        }
        String javaImplements = this.getOption(m.getOptions(), "java_implments", null);
        String implementsExpression = "";
        if (javaImplements != null) {
            implementsExpression = "implements " + javaImplements + " ";
        }
        String baseClass = "org.apache.activemq.protobuf.BaseMessage";
        if (this.deferredDecode) {
            baseClass = "org.apache.activemq.protobuf.DeferredDecodeMessage";
        }
        if (m.getBaseType() != null) {
            baseClass = this.javaType(m.getBaseType()) + "Base";
        }
        this.p(staticOption + "public final class " + className + " extends " + className + "Base<" + className + "> " + implementsExpression + "{");
        this.p();
        this.indent();
        for (EnumDescriptor enumType : m.getEnums().values()) {
            this.generateEnum(enumType);
        }
        for (MessageDescriptor subMessage : m.getMessages().values()) {
            this.generateMessageBean(subMessage);
        }
        for (FieldDescriptor field : m.getFields().values()) {
            if (this.isInBaseClass(m, field) || !field.isGroup()) continue;
            this.generateMessageBean(field.getGroup());
        }
        this.generateMethodAssertInitialized(m, className);
        this.generateMethodClear(m);
        this.p("public " + className + " clone() {");
        this.p("   return new " + className + "().mergeFrom(this);");
        this.p("}");
        this.p();
        this.generateMethodMergeFromBean(m, className);
        this.generateMethodSerializedSize(m);
        this.generateMethodMergeFromStream(m, className);
        this.generateMethodWriteTo(m);
        this.generateMethodParseFrom(m, className);
        this.generateMethodToString(m);
        this.generateMethodVisitor(m);
        this.generateMethodType(m, className);
        this.generateMethodEquals(m, className);
        this.unindent();
        this.p("}");
        this.p();
        this.p(staticOption + "abstract class " + className + "Base<T> extends " + baseClass + "<T> {");
        this.p();
        this.indent();
        for (FieldDescriptor field : m.getFields().values()) {
            if (this.isInBaseClass(m, field)) continue;
            this.generateFieldAccessor(field);
        }
        this.unindent();
        this.p("}");
        this.p();
    }

    private boolean isInBaseClass(MessageDescriptor m, FieldDescriptor field) {
        if (m.getBaseType() == null) {
            return false;
        }
        return m.getBaseType().getFields().containsKey(field.getName());
    }

    private void generateMethodVisitor(MessageDescriptor m) {
        String javaVisitor = this.getOption(m.getOptions(), "java_visitor", null);
        if (javaVisitor != null) {
            String returns = "void";
            String throwsException = null;
            StringTokenizer st = new StringTokenizer(javaVisitor, ":");
            String vistorClass = st.nextToken();
            if (st.hasMoreTokens()) {
                returns = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                throwsException = st.nextToken();
            }
            String throwsClause = "";
            if (throwsException != null) {
                throwsClause = "throws " + throwsException + " ";
            }
            this.p("public " + returns + " visit(" + vistorClass + " visitor) " + throwsClause + "{");
            this.indent();
            if ("void".equals(returns)) {
                this.p("visitor.visit(this);");
            } else {
                this.p("return visitor.visit(this);");
            }
            this.unindent();
            this.p("}");
            this.p();
        }
    }

    private void generateMethodType(MessageDescriptor m, String className) {
        String typeEnum = this.getOption(m.getOptions(), "java_type_method", null);
        if (typeEnum != null) {
            TypeDescriptor typeDescriptor = m.getType(typeEnum);
            if (typeDescriptor == null) {
                typeDescriptor = m.getProtoDescriptor().getType(typeEnum);
            }
            if (typeDescriptor == null || !typeDescriptor.isEnum()) {
                this.errors.add("The java_type_method option on the " + m.getName() + " message does not point to valid enum type");
                return;
            }
            String constant = this.constantCase(className);
            EnumDescriptor enumDescriptor = (EnumDescriptor)typeDescriptor;
            if (enumDescriptor.getFields().get(constant) == null) {
                this.errors.add("The java_type_method option on the " + m.getName() + " message does not points to the " + typeEnum + " enum but it does not have an entry for " + constant);
            }
            String type = this.javaType(typeDescriptor);
            this.p("public " + type + " type() {");
            this.indent();
            this.p("return " + type + "." + constant + ";");
            this.unindent();
            this.p("}");
            this.p();
        }
    }

    private void generateMethodParseFrom(MessageDescriptor m, String className) {
        String postMergeProcessing = ".checktInitialized()";
        if (this.deferredDecode) {
            postMergeProcessing = "";
        }
        this.p("public static " + className + " parseUnframed(org.apache.activemq.protobuf.CodedInputStream data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException, java.io.IOException {");
        this.indent();
        this.p("return new " + className + "().mergeUnframed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseUnframed(org.apache.activemq.protobuf.Buffer data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException {");
        this.indent();
        this.p("return new " + className + "().mergeUnframed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseUnframed(byte[] data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException {");
        this.indent();
        this.p("return new " + className + "().mergeUnframed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseUnframed(java.io.InputStream data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException, java.io.IOException {");
        this.indent();
        this.p("return new " + className + "().mergeUnframed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseFramed(org.apache.activemq.protobuf.CodedInputStream data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException, java.io.IOException {");
        this.indent();
        this.p("return new " + className + "().mergeFramed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseFramed(org.apache.activemq.protobuf.Buffer data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException {");
        this.indent();
        this.p("return new " + className + "().mergeFramed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseFramed(byte[] data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException {");
        this.indent();
        this.p("return new " + className + "().mergeFramed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public static " + className + " parseFramed(java.io.InputStream data) throws org.apache.activemq.protobuf.InvalidProtocolBufferException, java.io.IOException {");
        this.indent();
        this.p("return new " + className + "().mergeFramed(data)" + postMergeProcessing + ";");
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodEquals(MessageDescriptor m, String className) {
        this.p("public boolean equals(Object obj) {");
        this.indent();
        this.p("if( obj==this )");
        this.p("   return true;");
        this.p("");
        this.p("if( obj==null || obj.getClass()!=" + className + ".class )");
        this.p("   return false;");
        this.p("");
        this.p("return equals((" + className + ")obj);");
        this.unindent();
        this.p("}");
        this.p("");
        this.p("public boolean equals(" + className + " obj) {");
        this.indent();
        if (this.deferredDecode) {
            this.p("return toUnframedBuffer().equals(obj.toUnframedBuffer());");
        } else {
            for (FieldDescriptor field : m.getFields().values()) {
                String uname = JavaGenerator.uCamel(field.getName());
                String getterMethod = "get" + uname + "()";
                String hasMethod = "has" + uname + "()";
                if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                    getterMethod = "get" + uname + "List()";
                }
                this.p("if (" + hasMethod + " ^ obj." + hasMethod + " ) ");
                this.p("   return false;");
                if (field.getRule() != FieldDescriptor.REPEATED_RULE && (field.isNumberType() || field.getType() == FieldDescriptor.BOOL_TYPE)) {
                    this.p("if (" + hasMethod + " && ( " + getterMethod + "!=obj." + getterMethod + " ))");
                } else {
                    this.p("if (" + hasMethod + " && ( !" + getterMethod + ".equals(obj." + getterMethod + ") ))");
                }
                this.p("   return false;");
            }
            this.p("return true;");
        }
        this.unindent();
        this.p("}");
        this.p("");
        this.p("public int hashCode() {");
        this.indent();
        int hc = className.hashCode();
        if (this.deferredDecode) {
            this.p("return " + hc + " ^ toUnframedBuffer().hashCode();");
        } else {
            this.p("int rc=" + hc + ";");
            int counter = 0;
            for (FieldDescriptor field : m.getFields().values()) {
                ++counter;
                String uname = JavaGenerator.uCamel(field.getName());
                String getterMethod = "get" + uname + "()";
                String hasMethod = "has" + uname + "()";
                if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                    getterMethod = "get" + uname + "List()";
                }
                this.p("if (" + hasMethod + ") {");
                this.indent();
                if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                    this.p("rc ^= ( " + uname.hashCode() + "^" + getterMethod + ".hashCode() );");
                } else if (field.isInteger32Type()) {
                    this.p("rc ^= ( " + uname.hashCode() + "^" + getterMethod + " );");
                } else if (field.isInteger64Type()) {
                    this.p("rc ^= ( " + uname.hashCode() + "^(new Long(" + getterMethod + ")).hashCode() );");
                } else if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
                    this.p("rc ^= ( " + uname.hashCode() + "^(new Double(" + getterMethod + ")).hashCode() );");
                } else if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
                    this.p("rc ^= ( " + uname.hashCode() + "^(new Double(" + getterMethod + ")).hashCode() );");
                } else if (field.getType() == FieldDescriptor.BOOL_TYPE) {
                    this.p("rc ^= ( " + uname.hashCode() + "^ (" + getterMethod + "? " + counter + ":-" + counter + ") );");
                } else {
                    this.p("rc ^= ( " + uname.hashCode() + "^" + getterMethod + ".hashCode() );");
                }
                this.unindent();
                this.p("}");
            }
            this.p("return rc;");
        }
        this.unindent();
        this.p("}");
        this.p("");
    }

    private void generateMethodSerializedSize(MessageDescriptor m) {
        this.p("public int serializedSizeUnframed() {");
        this.indent();
        if (this.deferredDecode) {
            this.p("if (encodedForm != null) {");
            this.indent();
            this.p("return encodedForm.length;");
            this.unindent();
            this.p("}");
        }
        this.p("if (memoizedSerializedSize != -1)");
        this.p("   return memoizedSerializedSize;");
        this.p();
        this.p("int size = 0;");
        for (FieldDescriptor field : m.getFields().values()) {
            String uname = JavaGenerator.uCamel(field.getName());
            String getter = "get" + uname + "()";
            String type = this.javaType(field);
            this.p("if (has" + uname + "()) {");
            this.indent();
            if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                this.p("for (" + type + " i : get" + uname + "List()) {");
                this.indent();
                getter = "i";
            }
            if (field.getType() == FieldDescriptor.STRING_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeStringSize(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.BYTES_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeBytesSize(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.BOOL_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeBoolSize(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeDoubleSize(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeFloatSize(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.INT32_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeInt32Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.INT64_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeInt64Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SINT32_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeSInt32Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SINT64_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeSInt64Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.UINT32_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeUInt32Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.UINT64_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeUInt64Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FIXED32_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeFixed32Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FIXED64_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeFixed64Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SFIXED32_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeSFixed32Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SFIXED64_TYPE) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeSFixed64Size(" + field.getTag() + ", " + getter + ");");
            } else if (field.getTypeDescriptor().isEnum()) {
                this.p("size += org.apache.activemq.protobuf.CodedOutputStream.computeEnumSize(" + field.getTag() + ", " + getter + ".getNumber());");
            } else if (field.getGroup() != null) {
                this.p("size += computeGroupSize(" + field.getTag() + ", " + getter + ");");
            } else {
                this.p("size += computeMessageSize(" + field.getTag() + ", " + getter + ");");
            }
            if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                this.unindent();
                this.p("}");
            }
            this.unindent();
            this.p("}");
        }
        this.p("memoizedSerializedSize = size;");
        this.p("return size;");
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodWriteTo(MessageDescriptor m) {
        this.p("public void writeUnframed(org.apache.activemq.protobuf.CodedOutputStream output) throws java.io.IOException {");
        this.indent();
        if (this.deferredDecode) {
            this.p("if (encodedForm == null) {");
            this.indent();
            this.p("int size = serializedSizeUnframed();");
            this.p("encodedForm = output.getNextBuffer(size);");
            this.p("org.apache.activemq.protobuf.CodedOutputStream original=null;");
            this.p("if( encodedForm == null ) {");
            this.indent();
            this.p("encodedForm = new org.apache.activemq.protobuf.Buffer(new byte[size]);");
            this.p("original = output;");
            this.p("output = new org.apache.activemq.protobuf.CodedOutputStream(encodedForm);");
            this.unindent();
            this.p("}");
        }
        for (FieldDescriptor field : m.getFields().values()) {
            String uname = JavaGenerator.uCamel(field.getName());
            String getter = "get" + uname + "()";
            String type = this.javaType(field);
            this.p("if (has" + uname + "()) {");
            this.indent();
            if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                this.p("for (" + type + " i : get" + uname + "List()) {");
                this.indent();
                getter = "i";
            }
            if (field.getType() == FieldDescriptor.STRING_TYPE) {
                this.p("output.writeString(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.BYTES_TYPE) {
                this.p("output.writeBytes(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.BOOL_TYPE) {
                this.p("output.writeBool(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
                this.p("output.writeDouble(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
                this.p("output.writeFloat(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.INT32_TYPE) {
                this.p("output.writeInt32(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.INT64_TYPE) {
                this.p("output.writeInt64(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SINT32_TYPE) {
                this.p("output.writeSInt32(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SINT64_TYPE) {
                this.p("output.writeSInt64(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.UINT32_TYPE) {
                this.p("output.writeUInt32(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.UINT64_TYPE) {
                this.p("output.writeUInt64(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FIXED32_TYPE) {
                this.p("output.writeFixed32(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.FIXED64_TYPE) {
                this.p("output.writeFixed64(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SFIXED32_TYPE) {
                this.p("output.writeSFixed32(" + field.getTag() + ", " + getter + ");");
            } else if (field.getType() == FieldDescriptor.SFIXED64_TYPE) {
                this.p("output.writeSFixed64(" + field.getTag() + ", " + getter + ");");
            } else if (field.getTypeDescriptor().isEnum()) {
                this.p("output.writeEnum(" + field.getTag() + ", " + getter + ".getNumber());");
            } else if (field.getGroup() != null) {
                this.p("writeGroup(output, " + field.getTag() + ", " + getter + ");");
            } else {
                this.p("writeMessage(output, " + field.getTag() + ", " + getter + ");");
            }
            if (field.getRule() == FieldDescriptor.REPEATED_RULE) {
                this.unindent();
                this.p("}");
            }
            this.unindent();
            this.p("}");
        }
        if (this.deferredDecode) {
            this.p("if( original !=null ) {");
            this.indent();
            this.p("output.checkNoSpaceLeft();");
            this.p("output = original;");
            this.p("output.writeRawBytes(encodedForm);");
            this.unindent();
            this.p("}");
            this.unindent();
            this.p("} else {");
            this.indent();
            this.p("output.writeRawBytes(encodedForm);");
            this.unindent();
            this.p("}");
        }
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodMergeFromStream(MessageDescriptor m, String className) {
        this.p("public " + className + " mergeUnframed(org.apache.activemq.protobuf.CodedInputStream input) throws java.io.IOException {");
        this.indent();
        this.p("while (true) {");
        this.indent();
        this.p("int tag = input.readTag();");
        this.p("if ((tag & 0x07) == 4) {");
        this.p("   return this;");
        this.p("}");
        this.p("switch (tag) {");
        this.p("case 0:");
        this.p("   return this;");
        this.p("default: {");
        this.p("   break;");
        this.p("}");
        for (FieldDescriptor field : m.getFields().values()) {
            String type;
            boolean repeated;
            String uname = JavaGenerator.uCamel(field.getName());
            String setter = "set" + uname;
            boolean bl = repeated = field.getRule() == FieldDescriptor.REPEATED_RULE;
            if (repeated) {
                setter = "get" + uname + "List().add";
            }
            if (field.getType() == FieldDescriptor.STRING_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 2) + ":");
                this.indent();
                this.p(setter + "(input.readString());");
            } else if (field.getType() == FieldDescriptor.BYTES_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 2) + ":");
                this.indent();
                this.p(setter + "(input.readBytes());");
            } else if (field.getType() == FieldDescriptor.BOOL_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readBool());");
            } else if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 1) + ":");
                this.indent();
                this.p(setter + "(input.readDouble());");
            } else if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 5) + ":");
                this.indent();
                this.p(setter + "(input.readFloat());");
            } else if (field.getType() == FieldDescriptor.INT32_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readInt32());");
            } else if (field.getType() == FieldDescriptor.INT64_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readInt64());");
            } else if (field.getType() == FieldDescriptor.SINT32_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readSInt32());");
            } else if (field.getType() == FieldDescriptor.SINT64_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readSInt64());");
            } else if (field.getType() == FieldDescriptor.UINT32_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readUInt32());");
            } else if (field.getType() == FieldDescriptor.UINT64_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                this.p(setter + "(input.readUInt64());");
            } else if (field.getType() == FieldDescriptor.FIXED32_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 5) + ":");
                this.indent();
                this.p(setter + "(input.readFixed32());");
            } else if (field.getType() == FieldDescriptor.FIXED64_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 1) + ":");
                this.indent();
                this.p(setter + "(input.readFixed64());");
            } else if (field.getType() == FieldDescriptor.SFIXED32_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 5) + ":");
                this.indent();
                this.p(setter + "(input.readSFixed32());");
            } else if (field.getType() == FieldDescriptor.SFIXED64_TYPE) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 1) + ":");
                this.indent();
                this.p(setter + "(input.readSFixed64());");
            } else if (field.getTypeDescriptor().isEnum()) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 0) + ":");
                this.indent();
                type = this.javaType(field);
                this.p("{");
                this.indent();
                this.p("int t = input.readEnum();");
                this.p("" + type + " value = " + type + ".valueOf(t);");
                this.p("if( value !=null ) {");
                this.indent();
                this.p(setter + "(value);");
                this.unindent();
                this.p("}");
                this.unindent();
                this.p("}");
            } else if (field.getGroup() != null) {
                this.p("case " + WireFormat.makeTag(field.getTag(), 3) + ":");
                this.indent();
                type = this.javaType(field);
                if (repeated) {
                    this.p(setter + "(readGroup(input, " + field.getTag() + ", new " + type + "()));");
                } else {
                    this.p("if (has" + uname + "()) {");
                    this.indent();
                    this.p("readGroup(input, " + field.getTag() + ", get" + uname + "());");
                    this.unindent();
                    this.p("} else {");
                    this.indent();
                    this.p(setter + "(readGroup(input, " + field.getTag() + ",new " + type + "()));");
                    this.unindent();
                    this.p("}");
                }
                this.p("");
            } else {
                this.p("case " + WireFormat.makeTag(field.getTag(), 2) + ":");
                this.indent();
                type = this.javaType(field);
                if (repeated) {
                    this.p(setter + "(new " + type + "().mergeFramed(input));");
                } else {
                    this.p("if (has" + uname + "()) {");
                    this.indent();
                    this.p("get" + uname + "().mergeFramed(input);");
                    this.unindent();
                    this.p("} else {");
                    this.indent();
                    this.p(setter + "(new " + type + "().mergeFramed(input));");
                    this.unindent();
                    this.p("}");
                }
            }
            this.p("break;");
            this.unindent();
        }
        this.p("}");
        this.unindent();
        this.p("}");
        this.unindent();
        this.p("}");
    }

    private void generateMethodMergeFromBean(MessageDescriptor m, String className) {
        this.p("public " + className + " mergeFrom(" + className + " other) {");
        this.indent();
        for (FieldDescriptor field : m.getFields().values()) {
            String uname = JavaGenerator.uCamel(field.getName());
            this.p("if (other.has" + uname + "()) {");
            this.indent();
            if (field.isScalarType() || field.getTypeDescriptor().isEnum()) {
                if (field.isRepeated()) {
                    this.p("get" + uname + "List().addAll(other.get" + uname + "List());");
                } else {
                    this.p("set" + uname + "(other.get" + uname + "());");
                }
            } else {
                String type = this.javaType(field);
                if (field.isRepeated()) {
                    this.p("for(" + type + " element: other.get" + uname + "List() ) {");
                    this.indent();
                    this.p("get" + uname + "List().add(element.clone());");
                    this.unindent();
                    this.p("}");
                } else {
                    this.p("if (has" + uname + "()) {");
                    this.indent();
                    this.p("get" + uname + "().mergeFrom(other.get" + uname + "());");
                    this.unindent();
                    this.p("} else {");
                    this.indent();
                    this.p("set" + uname + "(other.get" + uname + "().clone());");
                    this.unindent();
                    this.p("}");
                }
            }
            this.unindent();
            this.p("}");
        }
        this.p("return this;");
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodClear(MessageDescriptor m) {
        this.p("public void clear() {");
        this.indent();
        this.p("super.clear();");
        for (FieldDescriptor field : m.getFields().values()) {
            String uname = JavaGenerator.uCamel(field.getName());
            this.p("clear" + uname + "();");
        }
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodAssertInitialized(MessageDescriptor m, String className) {
        String uname;
        this.p("public java.util.ArrayList<String> missingFields() {");
        this.indent();
        this.p("java.util.ArrayList<String> missingFields = super.missingFields();");
        for (FieldDescriptor field : m.getFields().values()) {
            uname = JavaGenerator.uCamel(field.getName());
            if (!field.isRequired()) continue;
            this.p("if(  !has" + uname + "() ) {");
            this.indent();
            this.p("missingFields.add(\"" + field.getName() + "\");");
            this.unindent();
            this.p("}");
        }
        if (!this.deferredDecode) {
            for (FieldDescriptor field : m.getFields().values()) {
                if (field.getTypeDescriptor() == null || field.getTypeDescriptor().isEnum()) continue;
                uname = JavaGenerator.uCamel(field.getName());
                this.p("if( has" + uname + "() ) {");
                this.indent();
                if (!field.isRepeated()) {
                    this.p("try {");
                    this.indent();
                    this.p("get" + uname + "().assertInitialized();");
                    this.unindent();
                    this.p("} catch (org.apache.activemq.protobuf.UninitializedMessageException e){");
                    this.indent();
                    this.p("missingFields.addAll(prefix(e.getMissingFields(),\"" + field.getName() + ".\"));");
                    this.unindent();
                    this.p("}");
                } else {
                    String type = this.javaCollectionType(field);
                    this.p("java.util.List<" + type + "> l = get" + uname + "List();");
                    this.p("for( int i=0; i < l.size(); i++ ) {");
                    this.indent();
                    this.p("try {");
                    this.indent();
                    this.p("l.get(i).assertInitialized();");
                    this.unindent();
                    this.p("} catch (org.apache.activemq.protobuf.UninitializedMessageException e){");
                    this.indent();
                    this.p("missingFields.addAll(prefix(e.getMissingFields(),\"" + field.getName() + "[\"+i+\"]\"));");
                    this.unindent();
                    this.p("}");
                    this.unindent();
                    this.p("}");
                }
                this.unindent();
                this.p("}");
            }
        }
        this.p("return missingFields;");
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateMethodToString(MessageDescriptor m) {
        this.p("public String toString() {");
        this.indent();
        this.p("return toString(new java.lang.StringBuilder(), \"\").toString();");
        this.unindent();
        this.p("}");
        this.p();
        this.p("public java.lang.StringBuilder toString(java.lang.StringBuilder sb, String prefix) {");
        this.indent();
        if (this.deferredDecode) {
            this.p("load();");
        }
        for (FieldDescriptor field : m.getFields().values()) {
            String uname = JavaGenerator.uCamel(field.getName());
            this.p("if(  has" + uname + "() ) {");
            this.indent();
            if (field.isRepeated()) {
                String type = this.javaCollectionType(field);
                this.p("java.util.List<" + type + "> l = get" + uname + "List();");
                this.p("for( int i=0; i < l.size(); i++ ) {");
                this.indent();
                if (field.getTypeDescriptor() != null && !field.getTypeDescriptor().isEnum()) {
                    this.p("sb.append(prefix+\"" + field.getName() + "[\"+i+\"] {\\n\");");
                    this.p("l.get(i).toString(sb, prefix+\"  \");");
                    this.p("sb.append(prefix+\"}\\n\");");
                } else {
                    this.p("sb.append(prefix+\"" + field.getName() + "[\"+i+\"]: \");");
                    this.p("sb.append(l.get(i));");
                    this.p("sb.append(\"\\n\");");
                }
                this.unindent();
                this.p("}");
            } else if (field.getTypeDescriptor() != null && !field.getTypeDescriptor().isEnum()) {
                this.p("sb.append(prefix+\"" + field.getName() + " {\\n\");");
                this.p("get" + uname + "().toString(sb, prefix+\"  \");");
                this.p("sb.append(prefix+\"}\\n\");");
            } else {
                this.p("sb.append(prefix+\"" + field.getName() + ": \");");
                this.p("sb.append(get" + uname + "());");
                this.p("sb.append(\"\\n\");");
            }
            this.unindent();
            this.p("}");
        }
        this.p("return sb;");
        this.unindent();
        this.p("}");
        this.p();
    }

    private void generateFieldAccessor(FieldDescriptor field) {
        String lname = JavaGenerator.lCamel(field.getName());
        String uname = JavaGenerator.uCamel(field.getName());
        String type = field.getRule() == FieldDescriptor.REPEATED_RULE ? this.javaCollectionType(field) : this.javaType(field);
        String typeDefault = this.javaTypeDefault(field);
        boolean primitive = field.getTypeDescriptor() == null || field.getTypeDescriptor().isEnum();
        boolean repeated = field.getRule() == FieldDescriptor.REPEATED_RULE;
        this.p("// " + field.getRule() + " " + field.getType() + " " + field.getName() + " = " + field.getTag() + ";");
        if (repeated) {
            this.p("private java.util.List<" + type + "> f_" + lname + ";");
            this.p();
            this.p("public boolean has" + uname + "() {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            this.p("return this.f_" + lname + "!=null && !this.f_" + lname + ".isEmpty();");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public java.util.List<" + type + "> get" + uname + "List() {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            this.p("if( this.f_" + lname + " == null ) {");
            this.indent();
            this.p("this.f_" + lname + " = new java.util.ArrayList<" + type + ">();");
            this.unindent();
            this.p("}");
            this.p("return this.f_" + lname + ";");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public T set" + uname + "List(java.util.List<" + type + "> " + lname + ") {");
            this.indent();
            this.p("loadAndClear();");
            this.p("this.f_" + lname + " = " + lname + ";");
            this.p("return (T)this;");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public int get" + uname + "Count() {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            this.p("if( this.f_" + lname + " == null ) {");
            this.indent();
            this.p("return 0;");
            this.unindent();
            this.p("}");
            this.p("return this.f_" + lname + ".size();");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public " + type + " get" + uname + "(int index) {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            this.p("if( this.f_" + lname + " == null ) {");
            this.indent();
            this.p("return null;");
            this.unindent();
            this.p("}");
            this.p("return this.f_" + lname + ".get(index);");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public T set" + uname + "(int index, " + type + " value) {");
            this.indent();
            this.p("loadAndClear();");
            this.p("get" + uname + "List().set(index, value);");
            this.p("return (T)this;");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public T add" + uname + "(" + type + " value) {");
            this.indent();
            this.p("loadAndClear();");
            this.p("get" + uname + "List().add(value);");
            this.p("return (T)this;");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public T addAll" + uname + "(java.lang.Iterable<? extends " + type + "> collection) {");
            this.indent();
            this.p("loadAndClear();");
            this.p("super.addAll(collection, get" + uname + "List());");
            this.p("return (T)this;");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public void clear" + uname + "() {");
            this.indent();
            this.p("loadAndClear();");
            this.p("this.f_" + lname + " = null;");
            this.unindent();
            this.p("}");
            this.p();
        } else {
            this.p("private " + type + " f_" + lname + " = " + typeDefault + ";");
            if (primitive) {
                this.p("private boolean b_" + lname + ";");
            }
            this.p();
            this.p("public boolean has" + uname + "() {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            if (primitive) {
                this.p("return this.b_" + lname + ";");
            } else {
                this.p("return this.f_" + lname + "!=null;");
            }
            this.unindent();
            this.p("}");
            this.p();
            this.p("public " + type + " get" + uname + "() {");
            this.indent();
            if (this.deferredDecode) {
                this.p("load();");
            }
            if (field.getTypeDescriptor() != null && !field.getTypeDescriptor().isEnum()) {
                this.p("if( this.f_" + lname + " == null ) {");
                this.indent();
                this.p("this.f_" + lname + " = new " + type + "();");
                this.unindent();
                this.p("}");
            }
            this.p("return this.f_" + lname + ";");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public T set" + uname + "(" + type + " " + lname + ") {");
            this.indent();
            this.p("loadAndClear();");
            if (primitive) {
                if (this.auto_clear_optional_fields && field.isOptional()) {
                    if (field.isStringType() && !"null".equals(typeDefault)) {
                        this.p("this.b_" + lname + " = (" + lname + " != " + typeDefault + ");");
                    } else {
                        this.p("this.b_" + lname + " = (" + lname + " != " + typeDefault + ");");
                    }
                } else {
                    this.p("this.b_" + lname + " = true;");
                }
            }
            this.p("this.f_" + lname + " = " + lname + ";");
            this.p("return (T)this;");
            this.unindent();
            this.p("}");
            this.p();
            this.p("public void clear" + uname + "() {");
            this.indent();
            this.p("loadAndClear();");
            if (primitive) {
                this.p("this.b_" + lname + " = false;");
            }
            this.p("this.f_" + lname + " = " + typeDefault + ";");
            this.unindent();
            this.p("}");
            this.p();
        }
    }

    private String javaTypeDefault(FieldDescriptor field) {
        OptionDescriptor defaultOption = field.getOptions().get("default");
        if (defaultOption != null) {
            if (field.isStringType()) {
                return this.asJavaString(defaultOption.getValue());
            }
            if (field.getType() == FieldDescriptor.BYTES_TYPE) {
                return "new org.apache.activemq.protobuf.Buffer(" + this.asJavaString(defaultOption.getValue()) + ")";
            }
            if (field.isInteger32Type()) {
                int v = field.getType() == FieldDescriptor.UINT32_TYPE ? TextFormat.parseUInt32(defaultOption.getValue()) : TextFormat.parseInt32(defaultOption.getValue());
                return "" + v;
            }
            if (field.isInteger64Type()) {
                long v = field.getType() == FieldDescriptor.UINT64_TYPE ? TextFormat.parseUInt64(defaultOption.getValue()) : TextFormat.parseInt64(defaultOption.getValue());
                return "" + v + "l";
            }
            if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
                double v = Double.valueOf(defaultOption.getValue());
                return "" + v + "d";
            }
            if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
                float v = Float.valueOf(defaultOption.getValue()).floatValue();
                return "" + v + "f";
            }
            if (field.getType() == FieldDescriptor.BOOL_TYPE) {
                boolean v = Boolean.valueOf(defaultOption.getValue());
                return "" + v;
            }
            if (field.getTypeDescriptor() != null && field.getTypeDescriptor().isEnum()) {
                return this.javaType(field) + "." + defaultOption.getValue();
            }
            return defaultOption.getValue();
        }
        if (field.isNumberType()) {
            return "0";
        }
        if (field.getType() == FieldDescriptor.BOOL_TYPE) {
            return "false";
        }
        return "null";
    }

    private String asJavaString(String value) {
        StringBuilder sb = new StringBuilder(value.length() + 2);
        sb.append("\"");
        block10: for (int i = 0; i < value.length(); ++i) {
            char b = value.charAt(i);
            switch (b) {
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                default: {
                    if (b >= ' ' && b < 'Z') {
                        sb.append(b);
                        continue block10;
                    }
                    sb.append("\\u");
                    sb.append(HEX_TABLE[b >>> 12 & 0xF]);
                    sb.append(HEX_TABLE[b >>> 8 & 0xF]);
                    sb.append(HEX_TABLE[b >>> 4 & 0xF]);
                    sb.append(HEX_TABLE[b & 0xF]);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private void generateEnum(EnumDescriptor ed) {
        String uname = JavaGenerator.uCamel(ed.getName());
        String staticOption = "static ";
        if (this.multipleFiles && ed.getParent() == null) {
            staticOption = "";
        }
        this.p();
        this.p("public " + staticOption + "enum " + uname + " {");
        this.indent();
        this.p();
        int counter = 0;
        for (EnumFieldDescriptor field : ed.getFields().values()) {
            boolean last = counter + 1 == ed.getFields().size();
            this.p(field.getName() + "(\"" + field.getName() + "\", " + field.getValue() + ")" + (last ? ";" : ","));
            ++counter;
        }
        this.p();
        this.p("private final String name;");
        this.p("private final int value;");
        this.p();
        this.p("private " + uname + "(String name, int value) {");
        this.p("   this.name = name;");
        this.p("   this.value = value;");
        this.p("}");
        this.p();
        this.p("public final int getNumber() {");
        this.p("   return value;");
        this.p("}");
        this.p();
        this.p("public final String toString() {");
        this.p("   return name;");
        this.p("}");
        this.p();
        this.p("public static " + uname + " valueOf(int value) {");
        this.p("   switch (value) {");
        HashSet<Integer> values = new HashSet<Integer>();
        for (EnumFieldDescriptor field : ed.getFields().values()) {
            if (values.contains(field.getValue())) continue;
            this.p("   case " + field.getValue() + ":");
            this.p("      return " + field.getName() + ";");
            values.add(field.getValue());
        }
        this.p("   default:");
        this.p("      return null;");
        this.p("   }");
        this.p("}");
        this.p();
        String createMessage = this.getOption(ed.getOptions(), "java_create_message", null);
        if ("true".equals(createMessage)) {
            this.p("public org.apache.activemq.protobuf.Message createMessage() {");
            this.indent();
            this.p("switch (this) {");
            this.indent();
            for (EnumFieldDescriptor field : ed.getFields().values()) {
                this.p("case " + field.getName() + ":");
                String type = this.constantToUCamelCase(field.getName());
                this.p("   return new " + type + "();");
            }
            this.p("default:");
            this.p("   return null;");
            this.unindent();
            this.p("}");
            this.unindent();
            this.p("}");
            this.p();
        }
        this.unindent();
        this.p("}");
        this.p();
    }

    private String javaCollectionType(FieldDescriptor field) {
        if (field.isInteger32Type()) {
            return "java.lang.Integer";
        }
        if (field.isInteger64Type()) {
            return "java.lang.Long";
        }
        if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
            return "java.lang.Double";
        }
        if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
            return "java.lang.Float";
        }
        if (field.getType() == FieldDescriptor.STRING_TYPE) {
            return "java.lang.String";
        }
        if (field.getType() == FieldDescriptor.BYTES_TYPE) {
            return "org.apache.activemq.protobuf.Buffer";
        }
        if (field.getType() == FieldDescriptor.BOOL_TYPE) {
            return "java.lang.Boolean";
        }
        TypeDescriptor descriptor = field.getTypeDescriptor();
        return this.javaType(descriptor);
    }

    private String javaType(FieldDescriptor field) {
        if (field.isInteger32Type()) {
            return "int";
        }
        if (field.isInteger64Type()) {
            return "long";
        }
        if (field.getType() == FieldDescriptor.DOUBLE_TYPE) {
            return "double";
        }
        if (field.getType() == FieldDescriptor.FLOAT_TYPE) {
            return "float";
        }
        if (field.getType() == FieldDescriptor.STRING_TYPE) {
            return "java.lang.String";
        }
        if (field.getType() == FieldDescriptor.BYTES_TYPE) {
            return "org.apache.activemq.protobuf.Buffer";
        }
        if (field.getType() == FieldDescriptor.BOOL_TYPE) {
            return "boolean";
        }
        TypeDescriptor descriptor = field.getTypeDescriptor();
        return this.javaType(descriptor);
    }

    private String javaType(TypeDescriptor descriptor) {
        ProtoDescriptor p = descriptor.getProtoDescriptor();
        if (p != this.proto) {
            String othePackage = this.javaPackage(p);
            if (this.equals(othePackage, this.javaPackage(this.proto))) {
                return this.javaClassName(p) + "." + descriptor.getQName();
            }
            return othePackage + "." + this.javaClassName(p) + "." + descriptor.getQName();
        }
        return descriptor.getQName();
    }

    private boolean equals(String o1, String o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private String javaClassName(ProtoDescriptor proto) {
        return this.getOption(proto.getOptions(), "java_outer_classname", JavaGenerator.uCamel(JavaGenerator.removeFileExtension(proto.getName())));
    }

    private boolean isMultipleFilesEnabled(ProtoDescriptor proto) {
        return "true".equals(this.getOption(proto.getOptions(), "java_multiple_files", "false"));
    }

    private String javaPackage(ProtoDescriptor proto) {
        String name = proto.getPackageName();
        if (name != null) {
            name = name.replace('-', '.');
            name = name.replace('/', '.');
        }
        return this.getOption(proto.getOptions(), "java_package", name);
    }

    private void indent() {
        ++this.indent;
    }

    private void unindent() {
        --this.indent;
    }

    private void p(String line) {
        for (int i = 0; i < this.indent; ++i) {
            this.w.print("   ");
        }
        this.w.println(line);
    }

    private void p() {
        this.w.println();
    }

    private String getOption(Map<String, OptionDescriptor> options, String optionName, String defaultValue) {
        OptionDescriptor optionDescriptor = options.get(optionName);
        if (optionDescriptor == null) {
            return defaultValue;
        }
        return optionDescriptor.getValue();
    }

    private static String removeFileExtension(String name) {
        return name.replaceAll("\\..*", "");
    }

    private static String uCamel(String name) {
        boolean upNext = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c) && Character.isLetterOrDigit(c)) {
                if (upNext) {
                    c = Character.toUpperCase(c);
                    upNext = false;
                }
                sb.append(c);
                continue;
            }
            upNext = true;
        }
        return sb.toString();
    }

    private static String lCamel(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        String uCamel = JavaGenerator.uCamel(name);
        return uCamel.substring(0, 1).toLowerCase() + uCamel.substring(1);
    }

    private String constantToUCamelCase(String name) {
        boolean upNext = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c) && Character.isLetterOrDigit(c)) {
                if (upNext) {
                    c = Character.toUpperCase(c);
                    upNext = false;
                } else {
                    c = Character.toLowerCase(c);
                }
                sb.append(c);
                continue;
            }
            upNext = true;
        }
        return sb.toString();
    }

    private String constantCase(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public File getOut() {
        return this.out;
    }

    public void setOut(File outputDirectory) {
        this.out = outputDirectory;
    }

    public File[] getPath() {
        return this.path;
    }

    public void setPath(File[] path) {
        this.path = path;
    }

    static interface Closure {
        public void execute() throws CompilerException;
    }
}

