/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQQueueSender;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicPublisher;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.pool.PooledMessageConsumer;
import org.apache.activemq.pool.PooledProducer;
import org.apache.activemq.pool.PooledQueueSender;
import org.apache.activemq.pool.PooledSessionEventListener;
import org.apache.activemq.pool.PooledTopicPublisher;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.pool.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledSession
implements Session,
TopicSession,
QueueSession,
XASession {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledSession.class);
    private final SessionKey key;
    private final KeyedObjectPool<SessionKey, PooledSession> sessionPool;
    private final CopyOnWriteArrayList<MessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<QueueBrowser> browsers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PooledSessionEventListener> sessionEventListeners = new CopyOnWriteArrayList();
    private ActiveMQSession session;
    private ActiveMQMessageProducer messageProducer;
    private ActiveMQQueueSender queueSender;
    private ActiveMQTopicPublisher topicPublisher;
    private boolean transactional = true;
    private boolean ignoreClose;
    private boolean isXa;

    public PooledSession(SessionKey key, ActiveMQSession session, KeyedObjectPool<SessionKey, PooledSession> sessionPool) {
        this.key = key;
        this.session = session;
        this.sessionPool = sessionPool;
        this.transactional = session.isTransacted();
    }

    public void addSessionEventListener(PooledSessionEventListener listener) {
        if (!this.sessionEventListeners.contains(listener)) {
            this.sessionEventListeners.add(listener);
        }
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (!this.ignoreClose) {
            boolean invalidate = false;
            try {
                this.getInternalSession().setMessageListener(null);
                for (MessageConsumer consumer : this.consumers) {
                    consumer.close();
                }
                for (QueueBrowser browser : this.browsers) {
                    browser.close();
                }
                if (this.transactional && !this.isXa) {
                    try {
                        this.getInternalSession().rollback();
                    }
                    catch (JMSException e) {
                        invalidate = true;
                        LOG.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + (Object)((Object)e), (Throwable)e);
                    }
                }
            }
            catch (JMSException ex) {
                invalidate = true;
                LOG.warn("Caught exception trying close() when putting session back into the pool, will invalidate. " + (Object)((Object)ex), (Throwable)ex);
            }
            finally {
                this.consumers.clear();
                this.browsers.clear();
                for (PooledSessionEventListener listener : this.sessionEventListeners) {
                    listener.onSessionClosed(this);
                }
                this.sessionEventListeners.clear();
            }
            if (invalidate) {
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace("Ignoring exception on close as discarding session: " + (Object)((Object)e1), (Throwable)e1);
                    }
                    this.session = null;
                }
                try {
                    this.sessionPool.invalidateObject((Object)this.key, (Object)this);
                }
                catch (Exception e) {
                    throw JMSExceptionSupport.create(e);
                }
            }
            try {
                this.sessionPool.returnObject((Object)this.key, (Object)this);
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    public void commit() throws JMSException {
        this.getInternalSession().commit();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getInternalSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getInternalSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getInternalSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getInternalSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getInternalSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getInternalSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getInternalSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TemporaryQueue result = this.getInternalSession().createTemporaryQueue();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryQueueCreate(result);
        }
        return result;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        TemporaryTopic result = this.getInternalSession().createTemporaryTopic();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryTopicCreate(result);
        }
        return result;
    }

    public void unsubscribe(String s) throws JMSException {
        this.getInternalSession().unsubscribe(s);
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getInternalSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getInternalSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getInternalSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getInternalSession().getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return this.getInternalSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getInternalSession().recover();
    }

    public void rollback() throws JMSException {
        this.getInternalSession().rollback();
    }

    public XAResource getXAResource() {
        if (this.session == null) {
            throw new IllegalStateException("Session is closed");
        }
        return this.session.getTransactionContext();
    }

    public Session getSession() {
        return this;
    }

    public void run() {
        if (this.session != null) {
            this.session.run();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue, selector));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination));
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector));
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector, noLocal));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, selector));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getInternalSession().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getInternalSession().setMessageListener(messageListener);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createSubscriber(topic));
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createSubscriber(topic, selector, local));
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.addQueueReceiver(this.getInternalSession().createReceiver(queue));
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return this.addQueueReceiver(this.getInternalSession().createReceiver(queue, selector));
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(), destination);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(), (Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(), (Destination)topic);
    }

    protected void onConsumerClose(MessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public ActiveMQSession getInternalSession() throws AlreadyClosedException {
        if (this.session == null) {
            throw new AlreadyClosedException("The session has already been closed");
        }
        return this.session;
    }

    public ActiveMQMessageProducer getMessageProducer() throws JMSException {
        if (this.messageProducer == null) {
            this.messageProducer = (ActiveMQMessageProducer)this.getInternalSession().createProducer(null);
        }
        return this.messageProducer;
    }

    public ActiveMQQueueSender getQueueSender() throws JMSException {
        if (this.queueSender == null) {
            this.queueSender = (ActiveMQQueueSender)this.getInternalSession().createSender(null);
        }
        return this.queueSender;
    }

    public ActiveMQTopicPublisher getTopicPublisher() throws JMSException {
        if (this.topicPublisher == null) {
            this.topicPublisher = (ActiveMQTopicPublisher)this.getInternalSession().createPublisher(null);
        }
        return this.topicPublisher;
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        this.consumers.add(consumer);
        return new PooledMessageConsumer(this, consumer);
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add((MessageConsumer)subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add((MessageConsumer)receiver);
        return receiver;
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public String toString() {
        return "PooledSession { " + this.session + " }";
    }
}

