/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.util.ByteSequence;

public final class JournalFacade
implements Journal {
    private final AsyncDataManager dataManager;

    public JournalFacade(AsyncDataManager dataManager) {
        this.dataManager = dataManager;
    }

    private static RecordLocation convertToRecordLocation(Location location) {
        if (location == null) {
            return null;
        }
        return new RecordLocationFacade(location);
    }

    private static Location convertFromRecordLocation(RecordLocation location) {
        if (location == null) {
            return null;
        }
        return ((RecordLocationFacade)location).getLocation();
    }

    public void close() throws IOException {
        this.dataManager.close();
    }

    public RecordLocation getMark() throws IllegalStateException {
        return JournalFacade.convertToRecordLocation(this.dataManager.getMark());
    }

    public RecordLocation getNextRecordLocation(RecordLocation location) throws InvalidRecordLocationException, IOException, IllegalStateException {
        return JournalFacade.convertToRecordLocation(this.dataManager.getNextLocation(JournalFacade.convertFromRecordLocation(location)));
    }

    public Packet read(RecordLocation location) throws InvalidRecordLocationException, IOException, IllegalStateException {
        ByteSequence rc = this.dataManager.read(JournalFacade.convertFromRecordLocation(location));
        if (rc == null) {
            return null;
        }
        return new ByteArrayPacket(rc.getData(), rc.getOffset(), rc.getLength());
    }

    public void setJournalEventListener(JournalEventListener listener) throws IllegalStateException {
    }

    public void setMark(RecordLocation location, boolean sync) throws InvalidRecordLocationException, IOException, IllegalStateException {
        this.dataManager.setMark(JournalFacade.convertFromRecordLocation(location), sync);
    }

    public RecordLocation write(Packet packet, boolean sync) throws IOException, IllegalStateException {
        org.apache.activeio.packet.ByteSequence data = packet.asByteSequence();
        ByteSequence sequence = new ByteSequence(data.getData(), data.getOffset(), data.getLength());
        return JournalFacade.convertToRecordLocation(this.dataManager.write(sequence, sync));
    }

    public RecordLocation write(Packet packet, Runnable onComplete2) throws IOException, IllegalStateException {
        org.apache.activeio.packet.ByteSequence data = packet.asByteSequence();
        ByteSequence sequence = new ByteSequence(data.getData(), data.getOffset(), data.getLength());
        return JournalFacade.convertToRecordLocation(this.dataManager.write(sequence, onComplete2));
    }

    public static class RecordLocationFacade
    implements RecordLocation {
        private final Location location;

        public RecordLocationFacade(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public int compareTo(Object o) {
            RecordLocationFacade rlf = (RecordLocationFacade)o;
            int rc = this.location.compareTo(rlf.location);
            return rc;
        }
    }
}

