/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.transport;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.transport.TransferType;

public class FastPathTransferType
implements AMQPType<Transfer>,
FastPathDescribedTypeConstructor<Transfer> {
    private static final byte DESCRIPTOR_CODE = 20;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(20L), Symbol.valueOf("amqp:transfer:list")};
    private final TransferType transferType;

    public FastPathTransferType(EncoderImpl encoder) {
        this.transferType = new TransferType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.transferType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.transferType.getDecoder();
    }

    @Override
    public Transfer readValue() {
        DecoderImpl decoder = this.getDecoder();
        byte typeCode = decoder.getBuffer().get();
        int size2 = 0;
        int count = 0;
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                size2 = decoder.getBuffer().get() & 0xFF;
                count = decoder.getBuffer().get() & 0xFF;
                break;
            }
            case -48: {
                size2 = decoder.getBuffer().getInt();
                count = decoder.getBuffer().getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Transfer encoding: " + typeCode);
            }
        }
        if (count < 1) {
            throw new DecodeException("The handle field cannot be omitted");
        }
        try {
            return this.readFields(decoder, count);
        }
        catch (NullPointerException npe) {
            throw new DecodeException("Unexpected null value - mandatory field not set? (" + npe.getMessage() + ")", npe);
        }
    }

    private final Transfer readFields(DecoderImpl decoder, int count) {
        Transfer transfer = new Transfer();
        block13: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    transfer.setHandle(decoder.readUnsignedInteger(null));
                    continue block13;
                }
                case 1: {
                    transfer.setDeliveryId(decoder.readUnsignedInteger(null));
                    continue block13;
                }
                case 2: {
                    transfer.setDeliveryTag(decoder.readBinary(null));
                    continue block13;
                }
                case 3: {
                    transfer.setMessageFormat(decoder.readUnsignedInteger(null));
                    continue block13;
                }
                case 4: {
                    transfer.setSettled(decoder.readBoolean(null));
                    continue block13;
                }
                case 5: {
                    transfer.setMore(decoder.readBoolean(false));
                    continue block13;
                }
                case 6: {
                    UnsignedByte rcvSettleMode = decoder.readUnsignedByte();
                    transfer.setRcvSettleMode(rcvSettleMode == null ? null : ReceiverSettleMode.values()[rcvSettleMode.intValue()]);
                    continue block13;
                }
                case 7: {
                    transfer.setState((DeliveryState)decoder.readObject());
                    continue block13;
                }
                case 8: {
                    transfer.setResume(decoder.readBoolean(false));
                    continue block13;
                }
                case 9: {
                    transfer.setAborted(decoder.readBoolean(false));
                    continue block13;
                }
                case 10: {
                    transfer.setBatchable(decoder.readBoolean(false));
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("To many entries in Transfer encoding");
                }
            }
        }
        return transfer;
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Transfer> getTypeClass() {
        return Transfer.class;
    }

    @Override
    public TypeEncoding<Transfer> getEncoding(Transfer transfer) {
        return this.transferType.getEncoding(transfer);
    }

    @Override
    public TypeEncoding<Transfer> getCanonicalEncoding() {
        return this.transferType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Transfer>> getAllEncodings() {
        return this.transferType.getAllEncodings();
    }

    @Override
    public void write(Transfer value) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        int count = this.getElementCount(value);
        byte encodingCode = this.deduceEncodingCode(value, count);
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)20);
        buffer.put(encodingCode);
        int fieldWidth = encodingCode == -64 ? 1 : 4;
        int startIndex = buffer.position();
        if (fieldWidth == 1) {
            buffer.put((byte)0);
            buffer.put((byte)count);
        } else {
            buffer.putInt(0);
            buffer.putInt(count);
        }
        for (int i = 0; i < count; ++i) {
            this.writeElement(value, i);
        }
        int endIndex = buffer.position();
        int writeSize = endIndex - startIndex - fieldWidth;
        buffer.position(startIndex);
        if (fieldWidth == 1) {
            buffer.put((byte)writeSize);
        } else {
            buffer.putInt(writeSize);
        }
        buffer.position(endIndex);
    }

    private void writeElement(Transfer transfer, int index) {
        switch (index) {
            case 0: {
                this.getEncoder().writeUnsignedInteger(transfer.getHandle());
                break;
            }
            case 1: {
                this.getEncoder().writeUnsignedInteger(transfer.getDeliveryId());
                break;
            }
            case 2: {
                this.getEncoder().writeBinary(transfer.getDeliveryTag());
                break;
            }
            case 3: {
                this.getEncoder().writeUnsignedInteger(transfer.getMessageFormat());
                break;
            }
            case 4: {
                this.getEncoder().writeBoolean(transfer.getSettled());
                break;
            }
            case 5: {
                this.getEncoder().writeBoolean(transfer.getMore());
                break;
            }
            case 6: {
                ReceiverSettleMode rcvSettleMode = transfer.getRcvSettleMode();
                this.getEncoder().writeObject(rcvSettleMode == null ? null : rcvSettleMode.getValue());
                break;
            }
            case 7: {
                this.getEncoder().writeObject(transfer.getState());
                break;
            }
            case 8: {
                this.getEncoder().writeBoolean(transfer.getResume());
                break;
            }
            case 9: {
                this.getEncoder().writeBoolean(transfer.getAborted());
                break;
            }
            case 10: {
                this.getEncoder().writeBoolean(transfer.getBatchable());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Transfer value index: " + index);
            }
        }
    }

    private byte deduceEncodingCode(Transfer value, int elementCount) {
        if (value.getState() != null) {
            return -48;
        }
        if (value.getDeliveryTag() != null && value.getDeliveryTag().getLength() > 200) {
            return -48;
        }
        return -64;
    }

    private int getElementCount(Transfer transfer) {
        if (transfer.getBatchable()) {
            return 11;
        }
        if (transfer.getAborted()) {
            return 10;
        }
        if (transfer.getResume()) {
            return 9;
        }
        if (transfer.getState() != null) {
            return 8;
        }
        if (transfer.getRcvSettleMode() != null) {
            return 7;
        }
        if (transfer.getMore()) {
            return 6;
        }
        if (transfer.getSettled() != null) {
            return 5;
        }
        if (transfer.getMessageFormat() != null) {
            return 4;
        }
        if (transfer.getDeliveryTag() != null) {
            return 3;
        }
        if (transfer.getDeliveryId() != null) {
            return 2;
        }
        return 1;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathTransferType type = new FastPathTransferType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

