/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.transport;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.transport.FlowType;

public class FastPathFlowType
implements AMQPType<Flow>,
FastPathDescribedTypeConstructor<Flow> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(19L), Symbol.valueOf("amqp:flow:list")};
    private final FlowType flowType;

    public FastPathFlowType(EncoderImpl encoder) {
        this.flowType = new FlowType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.flowType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.flowType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Flow> getTypeClass() {
        return Flow.class;
    }

    @Override
    public TypeEncoding<Flow> getEncoding(Flow flow) {
        return this.flowType.getEncoding(flow);
    }

    @Override
    public TypeEncoding<Flow> getCanonicalEncoding() {
        return this.flowType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Flow>> getAllEncodings() {
        return this.flowType.getAllEncodings();
    }

    @Override
    public Flow readValue() {
        DecoderImpl decoder = this.getDecoder();
        byte typeCode = decoder.getBuffer().get();
        int size2 = 0;
        int count = 0;
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                size2 = decoder.getBuffer().get() & 0xFF;
                count = decoder.getBuffer().get() & 0xFF;
                break;
            }
            case -48: {
                size2 = decoder.getBuffer().getInt();
                count = decoder.getBuffer().getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Flow encoding: " + typeCode);
            }
        }
        Flow flow = new Flow();
        block18: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    flow.setNextIncomingId(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 1: {
                    flow.setIncomingWindow(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 2: {
                    flow.setNextOutgoingId(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 3: {
                    flow.setOutgoingWindow(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 4: {
                    flow.setHandle(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 5: {
                    flow.setDeliveryCount(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 6: {
                    flow.setLinkCredit(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 7: {
                    flow.setAvailable(decoder.readUnsignedInteger());
                    continue block18;
                }
                case 8: {
                    flow.setDrain(decoder.readBoolean(false));
                    continue block18;
                }
                case 9: {
                    flow.setEcho(decoder.readBoolean(false));
                    continue block18;
                }
                case 10: {
                    flow.setProperties(decoder.readMap());
                    continue block18;
                }
                default: {
                    throw new IllegalStateException("To many entries in Flow encoding");
                }
            }
        }
        return flow;
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(Flow flow) {
        int fieldWidth;
        WritableBuffer buffer = this.getEncoder().getBuffer();
        int count = this.getElementCount(flow);
        byte encodingCode = this.deduceEncodingCode(flow, count);
        buffer.put((byte)0);
        this.getEncoder().writeUnsignedLong(this.flowType.getDescriptor());
        if (encodingCode == -64) {
            fieldWidth = 1;
            buffer.put((byte)-64);
        } else {
            fieldWidth = 4;
            buffer.put((byte)-48);
        }
        int startIndex = buffer.position();
        if (fieldWidth == 1) {
            buffer.put((byte)0);
            buffer.put((byte)count);
        } else {
            buffer.putInt(0);
            buffer.putInt(count);
        }
        for (int i = 0; i < count; ++i) {
            this.writeElement(flow, i);
        }
        int endIndex = buffer.position();
        int writeSize = endIndex - startIndex - fieldWidth;
        buffer.position(startIndex);
        if (fieldWidth == 1) {
            buffer.put((byte)writeSize);
        } else {
            buffer.putInt(writeSize);
        }
        buffer.position(endIndex);
    }

    private void writeElement(Flow flow, int index) {
        switch (index) {
            case 0: {
                this.getEncoder().writeUnsignedInteger(flow.getNextIncomingId());
                break;
            }
            case 1: {
                this.getEncoder().writeUnsignedInteger(flow.getIncomingWindow());
                break;
            }
            case 2: {
                this.getEncoder().writeUnsignedInteger(flow.getNextOutgoingId());
                break;
            }
            case 3: {
                this.getEncoder().writeUnsignedInteger(flow.getOutgoingWindow());
                break;
            }
            case 4: {
                this.getEncoder().writeUnsignedInteger(flow.getHandle());
                break;
            }
            case 5: {
                this.getEncoder().writeUnsignedInteger(flow.getDeliveryCount());
                break;
            }
            case 6: {
                this.getEncoder().writeUnsignedInteger(flow.getLinkCredit());
                break;
            }
            case 7: {
                this.getEncoder().writeUnsignedInteger(flow.getAvailable());
                break;
            }
            case 8: {
                this.getEncoder().writeBoolean(flow.getDrain());
                break;
            }
            case 9: {
                this.getEncoder().writeBoolean(flow.getEcho());
                break;
            }
            case 10: {
                this.getEncoder().writeMap(flow.getProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Flow value index: " + index);
            }
        }
    }

    private int getElementCount(Flow flow) {
        if (flow.getProperties() != null) {
            return 11;
        }
        if (flow.getEcho()) {
            return 10;
        }
        if (flow.getDrain()) {
            return 9;
        }
        if (flow.getAvailable() != null) {
            return 8;
        }
        if (flow.getLinkCredit() != null) {
            return 7;
        }
        if (flow.getDeliveryCount() != null) {
            return 6;
        }
        if (flow.getHandle() != null) {
            return 5;
        }
        return 4;
    }

    private byte deduceEncodingCode(Flow value, int elementCount) {
        if (value.getProperties() == null) {
            return -64;
        }
        return -48;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathFlowType type = new FastPathFlowType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

