/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPMessageIdHelper;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.AmqpMessageSupport;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.OutboundTransformer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;

public class JMSMappingOutboundTransformer
extends OutboundTransformer {
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf("x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf("x-opt-jms-reply-to");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final Symbol LEGACY_JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf("x-opt-to-type");
    public static final Symbol LEGACY_JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf("x-opt-reply-type");
    public static final String LEGACY_QUEUE_TYPE = "queue";
    public static final String LEGACY_TOPIC_TYPE = "topic";
    public static final String LEGACY_TEMP_QUEUE_TYPE = "temporary,queue";
    public static final String LEGACY_TEMP_TOPIC_TYPE = "temporary,topic";

    public JMSMappingOutboundTransformer(ActiveMQJMSVendor vendor) {
        super(vendor);
    }

    @Override
    public EncodedMessage transform(Message msg) throws Exception {
        long messageFormat;
        if (msg == null) {
            return null;
        }
        try {
            if (msg.getBooleanProperty(this.prefixVendor + "NATIVE")) {
                return null;
            }
        }
        catch (MessageFormatException e) {
            return null;
        }
        ProtonJMessage amqp = this.convert(msg);
        try {
            messageFormat = msg.getLongProperty(this.messageFormatKey);
        }
        catch (MessageFormatException e) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4096]);
        DroppingWritableBuffer overflow = new DroppingWritableBuffer();
        int c = amqp.encode(new CompositeWritableBuffer(new WritableBuffer.ByteBufferWrapper(buffer), overflow));
        if (overflow.position() > 0) {
            buffer = ByteBuffer.wrap(new byte[4096 + overflow.position()]);
            c = amqp.encode(new WritableBuffer.ByteBufferWrapper(buffer));
        }
        return new EncodedMessage(messageFormat, buffer.array(), 0, c);
    }

    public ProtonJMessage convert(Message message) throws JMSException, UnsupportedEncodingException {
        Header header = new Header();
        Properties props = new Properties();
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Object> maMap = null;
        HashMap<String, String> apMap = null;
        HashMap<String, Object> footerMap = null;
        Section body = null;
        body = this.convertBody(message);
        header.setDurable(message.getJMSDeliveryMode() == 2);
        header.setPriority(new UnsignedByte((byte)message.getJMSPriority()));
        if (message.getJMSType() != null) {
            props.setSubject(message.getJMSType());
        }
        if (message.getJMSMessageID() != null) {
            props.setMessageId(this.vendor.getOriginalMessageId(message));
        }
        if (message.getJMSDestination() != null) {
            props.setTo(this.vendor.toAddress(message.getJMSDestination()));
            if (maMap == null) {
                maMap = new HashMap<Symbol, Object>();
            }
            maMap.put(JMS_DEST_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(message.getJMSDestination()));
            maMap.put(LEGACY_JMS_DEST_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationAttributes(message.getJMSDestination()));
        }
        if (message.getJMSReplyTo() != null) {
            props.setReplyTo(this.vendor.toAddress(message.getJMSReplyTo()));
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put(JMS_REPLY_TO_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(message.getJMSReplyTo()));
            maMap.put(LEGACY_JMS_REPLY_TO_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationAttributes(message.getJMSReplyTo()));
        }
        if (message.getJMSCorrelationID() != null) {
            String correlationId = message.getJMSCorrelationID();
            try {
                props.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(correlationId));
            }
            catch (AmqpProtocolException e) {
                props.setCorrelationId(correlationId);
            }
        }
        if (message.getJMSExpiration() != 0L) {
            long ttl = message.getJMSExpiration() - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            props.setAbsoluteExpiryTime(new Date(message.getJMSExpiration()));
        }
        if (message.getJMSTimestamp() != 0L) {
            props.setCreationTime(new Date(message.getJMSTimestamp()));
        }
        Enumeration keys = message.getPropertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(this.messageFormatKey) || key.equals(this.nativeKey) || key.equals("JMS_AMQP_ORIGINAL_ENCODING")) continue;
            if (key.equals(this.firstAcquirerKey)) {
                header.setFirstAcquirer(message.getBooleanProperty(key));
                continue;
            }
            if (key.startsWith("JMSXDeliveryCount")) {
                int amqpDeliveryCount = message.getIntProperty(key) - 1;
                if (amqpDeliveryCount <= 0) continue;
                header.setDeliveryCount(new UnsignedInteger(amqpDeliveryCount));
                continue;
            }
            if (key.startsWith("JMSXUserID")) {
                String value = message.getStringProperty(key);
                props.setUserId(new Binary(value.getBytes("UTF-8")));
                continue;
            }
            if (key.startsWith("JMSXGroupID")) {
                String value = message.getStringProperty(key);
                props.setGroupId(value);
                if (apMap == null) {
                    apMap = new HashMap<String, String>();
                }
                apMap.put(key, value);
                continue;
            }
            if (key.startsWith("JMSXGroupSeq")) {
                UnsignedInteger value = new UnsignedInteger(message.getIntProperty(key));
                props.setGroupSequence(value);
                if (apMap == null) {
                    apMap = new HashMap();
                }
                apMap.put(key, (String)((Object)value));
                continue;
            }
            if (key.startsWith(this.prefixDeliveryAnnotationsKey)) {
                if (daMap == null) {
                    daMap = new HashMap<Symbol, Object>();
                }
                String name = key.substring(this.prefixDeliveryAnnotationsKey.length());
                daMap.put(Symbol.valueOf(name), message.getObjectProperty(key));
                continue;
            }
            if (key.startsWith(this.prefixMessageAnnotationsKey)) {
                if (maMap == null) {
                    maMap = new HashMap();
                }
                String name = key.substring(this.prefixMessageAnnotationsKey.length());
                maMap.put(Symbol.valueOf(name), message.getObjectProperty(key));
                continue;
            }
            if (key.equals(this.contentTypeKey)) {
                props.setContentType(Symbol.getSymbol(message.getStringProperty(key)));
                continue;
            }
            if (key.equals(this.contentEncodingKey)) {
                props.setContentEncoding(Symbol.getSymbol(message.getStringProperty(key)));
                continue;
            }
            if (key.equals(this.replyToGroupIDKey)) {
                props.setReplyToGroupId(message.getStringProperty(key));
                continue;
            }
            if (key.startsWith(this.prefixFooterKey)) {
                if (footerMap == null) {
                    footerMap = new HashMap<String, Object>();
                }
                String name = key.substring(this.prefixFooterKey.length());
                footerMap.put(name, message.getObjectProperty(key));
                continue;
            }
            if (apMap == null) {
                apMap = new HashMap();
            }
            apMap.put(key, (String)message.getObjectProperty(key));
        }
        MessageAnnotations ma = null;
        if (maMap != null) {
            ma = new MessageAnnotations(maMap);
        }
        DeliveryAnnotations da = null;
        if (daMap != null) {
            da = new DeliveryAnnotations(daMap);
        }
        ApplicationProperties ap = null;
        if (apMap != null) {
            ap = new ApplicationProperties(apMap);
        }
        Footer footer = null;
        if (footerMap != null) {
            footer = new Footer(footerMap);
        }
        return (ProtonJMessage)Message.Factory.create(header, da, ma, props, ap, body, footer);
    }

    private Section convertBody(Message message) throws JMSException {
        Section body = null;
        short orignalEncoding = 0;
        if (message.propertyExists("JMS_AMQP_ORIGINAL_ENCODING")) {
            try {
                orignalEncoding = message.getShortProperty("JMS_AMQP_ORIGINAL_ENCODING");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message instanceof BytesMessage) {
            Binary payload = this.vendor.getBinaryFromMessageBody((BytesMessage)message);
            if (payload == null) {
                payload = AmqpMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 6: {
                    body = new AmqpValue(payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                    break;
                }
            }
        } else if (message instanceof TextMessage) {
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 2: {
                    body = new Data(this.vendor.getBinaryFromMessageBody((TextMessage)message));
                    break;
                }
                default: {
                    body = new AmqpValue(((TextMessage)message).getText());
                    break;
                }
            }
        } else if (message instanceof MapMessage) {
            body = new AmqpValue(this.vendor.getMapFromMessageBody((MapMessage)message));
        } else if (message instanceof StreamMessage) {
            ArrayList<Object> list = new ArrayList<Object>();
            StreamMessage m = (StreamMessage)message;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                switch (orignalEncoding) {
                    case 3: {
                        body = new AmqpSequence(list);
                        break;
                    }
                    default: {
                        body = new AmqpValue(list);
                        break;
                    }
                }
            }
        } else if (message instanceof ObjectMessage) {
            Binary payload = this.vendor.getBinaryFromMessageBody((ObjectMessage)message);
            if (payload == null) {
                payload = AmqpMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 6: {
                    body = new AmqpValue(payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                }
            }
            if (!message.propertyExists(this.contentTypeKey)) {
                this.vendor.setMessageProperty(message, this.contentTypeKey, "application/x-java-serialized-object");
            }
        }
        return body;
    }

    private static byte destinationType(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return 2;
            }
            return 0;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return 3;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }

    @Deprecated
    private static String destinationAttributes(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return LEGACY_TEMP_QUEUE_TYPE;
            }
            return LEGACY_QUEUE_TYPE;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return LEGACY_TEMP_TOPIC_TYPE;
            }
            return LEGACY_TOPIC_TYPE;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }
}

