/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.io.DataInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPMessageIdHelper;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.qpid.proton.amqp.Binary;

public class ActiveMQJMSVendor {
    public static final ActiveMQJMSVendor INSTANCE = new ActiveMQJMSVendor();

    private ActiveMQJMSVendor() {
    }

    public Message createMessage() {
        return new ActiveMQMessage();
    }

    public BytesMessage createBytesMessage() {
        return new ActiveMQBytesMessage();
    }

    public BytesMessage createBytesMessage(byte[] content, int offset, int length) {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public StreamMessage createStreamMessage() {
        return new ActiveMQStreamMessage();
    }

    public TextMessage createTextMessage() {
        return new ActiveMQTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        try {
            message.setText(text);
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        return message;
    }

    public ObjectMessage createObjectMessage() {
        return new ActiveMQObjectMessage();
    }

    public ObjectMessage createObjectMessage(byte[] content, int offset, int length) {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public MapMessage createMapMessage() {
        return new ActiveMQMapMessage();
    }

    public MapMessage createMapMessage(Map<String, Object> content) throws JMSException {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Set<Map.Entry<String, Object>> set2 = content.entrySet();
        for (Map.Entry<String, Object> entry : set2) {
            message.setObject(entry.getKey(), entry.getValue());
        }
        return message;
    }

    public Destination createDestination(String name) {
        return ActiveMQDestination.createDestination(name, (byte)1);
    }

    public void setJMSXUserID(Message msg, String value) {
        ((ActiveMQMessage)msg).setUserID(value);
    }

    public void setJMSXGroupID(Message msg, String value) {
        ((ActiveMQMessage)msg).setGroupID(value);
    }

    public void setJMSXGroupSequence(Message msg, int value) {
        ((ActiveMQMessage)msg).setGroupSequence(value);
    }

    public void setJMSXDeliveryCount(Message msg, long value) {
        ((ActiveMQMessage)msg).setRedeliveryCounter((int)value);
    }

    public String toAddress(Destination dest) {
        return ((ActiveMQDestination)dest).getQualifiedName();
    }

    public Object getOriginalMessageId(Message message) {
        Object result;
        MessageId msgId = ((ActiveMQMessage)message).getMessageId();
        if (msgId.getTextView() != null) {
            try {
                result = AMQPMessageIdHelper.INSTANCE.toIdObject(msgId.getTextView());
            }
            catch (AmqpProtocolException e) {
                result = msgId.getTextView().toString();
            }
        } else {
            result = msgId.toString();
        }
        return result;
    }

    public Binary getBinaryFromMessageBody(BytesMessage message) throws JMSException {
        ActiveMQBytesMessage bytesMessage = (ActiveMQBytesMessage)message;
        Binary result = null;
        if (bytesMessage.getContent() != null) {
            ByteSequence contents = bytesMessage.getContent();
            if (bytesMessage.isCompressed()) {
                int length = (int)bytesMessage.getBodyLength();
                byte[] uncompressed = new byte[length];
                bytesMessage.readBytes(uncompressed);
                result = new Binary(uncompressed);
            } else {
                return new Binary(contents.getData(), contents.getOffset(), contents.getLength());
            }
        }
        return result;
    }

    public Binary getBinaryFromMessageBody(ObjectMessage message) throws JMSException {
        Binary result;
        block41: {
            ActiveMQObjectMessage objectMessage = (ActiveMQObjectMessage)message;
            result = null;
            if (objectMessage.getContent() != null) {
                ByteSequence contents = objectMessage.getContent();
                if (objectMessage.isCompressed()) {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();
                         ByteArrayInputStream is = new ByteArrayInputStream(contents);
                         InflaterInputStream iis = new InflaterInputStream(is);){
                        byte value;
                        while ((value = (byte)iis.read()) != -1) {
                            os.write(value);
                        }
                        ByteSequence expanded = os.toByteSequence();
                        result = new Binary(expanded.getData(), expanded.getOffset(), expanded.getLength());
                        break block41;
                    }
                    catch (Exception cause) {
                        throw JMSExceptionSupport.create(cause);
                    }
                }
                return new Binary(contents.getData(), contents.getOffset(), contents.getLength());
            }
        }
        return result;
    }

    public Binary getBinaryFromMessageBody(TextMessage message) throws JMSException {
        Binary result;
        block40: {
            ActiveMQTextMessage textMessage = (ActiveMQTextMessage)message;
            result = null;
            if (textMessage.getContent() != null) {
                ByteSequence contents = textMessage.getContent();
                if (textMessage.isCompressed()) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(contents);
                         InflaterInputStream iis = new InflaterInputStream(is);
                         DataInputStream dis = new DataInputStream(iis);){
                        int size2 = dis.readInt();
                        byte[] uncompressed = new byte[size2];
                        dis.readFully(uncompressed);
                        result = new Binary(uncompressed);
                        break block40;
                    }
                    catch (Exception cause) {
                        throw JMSExceptionSupport.create(cause);
                    }
                }
                result = new Binary(contents.getData(), contents.getOffset() + 4, contents.getLength() - 4);
            }
        }
        return result;
    }

    public Map<String, Object> getMapFromMessageBody(MapMessage message) throws JMSException {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        ActiveMQMapMessage mapMessage = (ActiveMQMapMessage)message;
        Map<String, Object> contentMap = mapMessage.getContentMap();
        if (contentMap != null) {
            map2.putAll(contentMap);
        }
        return contentMap;
    }

    public void setMessageProperty(Message message, String key, Object value) throws JMSException {
        ActiveMQMessage amqMessage = (ActiveMQMessage)message;
        boolean oldValue = amqMessage.isReadOnlyProperties();
        amqMessage.setReadOnlyProperties(false);
        amqMessage.setObjectProperty(key, value);
        amqMessage.setReadOnlyProperties(oldValue);
    }
}

