/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.util.Map;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.TypeConversionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableConduitBridge
extends ConduitBridge {
    private static final Logger LOG = LoggerFactory.getLogger(DurableConduitBridge.class);

    public String toString() {
        return "DurableConduitBridge:" + this.configuration.getBrokerName() + "->" + this.getRemoteBrokerName();
    }

    public DurableConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    @Override
    protected void setupStaticDestinations() {
        ActiveMQDestination[] dests;
        super.setupStaticDestinations();
        ActiveMQDestination[] activeMQDestinationArray = dests = this.configuration.isDynamicOnly() ? null : this.durableDestinations;
        if (dests != null) {
            for (ActiveMQDestination dest : dests) {
                block5: {
                    if (!this.isPermissableDestination(dest) || this.doesConsumerExist(dest)) continue;
                    try {
                        if (!dest.isTopic()) break block5;
                        RegionBroker regionBroker = (RegionBroker)this.brokerService.getRegionBroker();
                        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
                        String candidateSubName = this.getSubscriberName(dest);
                        for (Subscription subscription : topicRegion.getDurableSubscriptions().values()) {
                            String subName = subscription.getConsumerInfo().getSubscriptionName();
                            if (subName == null || !subName.equals(candidateSubName)) continue;
                            DemandSubscription sub = this.createDemandSubscription(dest, subName);
                            sub.getLocalInfo().setSubscriptionName(this.getSubscriberName(dest));
                            sub.setStaticallyIncluded(true);
                            this.addSubscription(sub);
                            break;
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Failed to add static destination {}", (Object)dest, (Object)e);
                    }
                }
                LOG.trace("Forwarding messages for durable destination: {}", (Object)dest);
            }
        }
    }

    @Override
    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        ConsumerId forcedDurableId;
        boolean isForcedDurable = this.isForcedDurable(info);
        if (this.addToAlreadyInterestedConsumers(info, isForcedDurable)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        ConsumerId consumerId = forcedDurableId = isForcedDurable ? info.getConsumerId() : null;
        if (info.isDurable() || isForcedDurable) {
            info.setSubscriptionName(this.getSubscriberName(info.getDestination()));
            info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        }
        info.setSelector(null);
        DemandSubscription demandSubscription = this.doCreateDemandSubscription(info);
        if (forcedDurableId != null) {
            demandSubscription.addForcedDurableConsumer(forcedDurableId);
            this.forcedDurableRemoteId.add(forcedDurableId);
        }
        return demandSubscription;
    }

    private boolean isForcedDurable(ConsumerInfo info) {
        if (info.isDurable()) {
            return false;
        }
        ActiveMQDestination destination = info.getDestination();
        if (AdvisorySupport.isAdvisoryTopic(destination) || destination.isTemporary() || destination.isQueue()) {
            return false;
        }
        ActiveMQDestination matching = this.findMatchingDestination(this.dynamicallyIncludedDestinations, destination);
        if (matching != null) {
            return this.isDestForcedDurable(matching);
        }
        matching = this.findMatchingDestination(this.staticallyIncludedDestinations, destination);
        if (matching != null) {
            return this.isDestForcedDurable(matching);
        }
        return false;
    }

    private boolean isDestForcedDurable(ActiveMQDestination destination) {
        Map<String, String> options = destination.getOptions();
        boolean isForceDurable = false;
        if (options != null) {
            isForceDurable = (Boolean)TypeConversionSupport.convert(options.get("forceDurable"), Boolean.TYPE);
        }
        return isForceDurable;
    }

    protected String getSubscriberName(ActiveMQDestination dest) {
        String subscriberName = "NC-DS_" + this.configuration.getBrokerName() + "_" + dest.getPhysicalName();
        return subscriberName;
    }

    protected boolean doesConsumerExist(ActiveMQDestination dest) {
        DestinationFilter filter = DestinationFilter.parseFilter(dest);
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            return true;
        }
        return false;
    }
}

