/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt.strategy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTProtocolSupport;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.transport.mqtt.strategy.AbstractMQTTSubscriptionStrategy;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.CONNECT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTVirtualTopicSubscriptionStrategy
extends AbstractMQTTSubscriptionStrategy {
    private static final String VIRTUALTOPIC_PREFIX = "VirtualTopic.";
    private static final String VIRTUALTOPIC_CONSUMER_PREFIX = "Consumer.";
    private static final Logger LOG = LoggerFactory.getLogger(MQTTVirtualTopicSubscriptionStrategy.class);
    private final Set<ActiveMQQueue> restoredQueues = Collections.synchronizedSet(new HashSet());

    @Override
    public void onConnect(CONNECT connect) throws MQTTProtocolException {
        List<ActiveMQQueue> queues = this.lookupQueues(this.protocol.getClientId());
        List<SubscriptionInfo> subs = this.lookupSubscription(this.protocol.getClientId());
        if (connect.cleanSession()) {
            this.deleteDurableQueues(queues);
            this.deleteDurableSubs(subs);
        } else {
            this.restoreDurableQueue(queues);
            this.restoreDurableSubs(subs);
        }
    }

    @Override
    public byte onSubscribe(String topicName, QoS requestedQoS) throws MQTTProtocolException {
        ActiveMQDestination destination = null;
        int prefetch = 1000;
        ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
        if (!this.protocol.isCleanSession() && this.protocol.getClientId() != null && requestedQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            String converted = MQTTProtocolSupport.convertMQTTToActiveMQ(topicName);
            if (converted.startsWith(VIRTUALTOPIC_PREFIX)) {
                destination = new ActiveMQTopic(converted);
                prefetch = 100;
                consumerInfo.setSubscriptionName((Object)((Object)requestedQoS) + ":" + topicName);
            } else {
                converted = VIRTUALTOPIC_CONSUMER_PREFIX + this.protocol.getClientId() + ":" + (Object)((Object)requestedQoS) + "." + VIRTUALTOPIC_PREFIX + converted;
                destination = new ActiveMQQueue(converted);
                prefetch = 1000;
            }
        } else {
            String converted = MQTTProtocolSupport.convertMQTTToActiveMQ(topicName);
            if (!converted.startsWith(VIRTUALTOPIC_PREFIX)) {
                converted = VIRTUALTOPIC_PREFIX + converted;
            }
            destination = new ActiveMQTopic(converted);
            prefetch = Short.MAX_VALUE;
        }
        consumerInfo.setDestination(destination);
        if (this.protocol.getActiveMQSubscriptionPrefetch() > 0) {
            consumerInfo.setPrefetchSize(this.protocol.getActiveMQSubscriptionPrefetch());
        } else {
            consumerInfo.setPrefetchSize(prefetch);
        }
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        return this.doSubscribe(consumerInfo, topicName, requestedQoS);
    }

    @Override
    public void onReSubscribe(MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        ActiveMQDestination destination = mqttSubscription.getDestination();
        if (destination.isQueue() && this.restoredQueues.remove(destination)) {
            return;
        }
        if (destination.isTopic() && this.restoredDurableSubs.remove(destination.getPhysicalName())) {
            return;
        }
        if (mqttSubscription.getDestination().isTopic()) {
            super.onReSubscribe(mqttSubscription);
        } else {
            this.doUnSubscribe(mqttSubscription);
            ConsumerInfo consumerInfo = mqttSubscription.getConsumerInfo();
            consumerInfo.setConsumerId(this.getNextConsumerId());
            this.doSubscribe(consumerInfo, mqttSubscription.getTopicName(), mqttSubscription.getQoS());
        }
    }

    @Override
    public void onUnSubscribe(String topicName) throws MQTTProtocolException {
        MQTTSubscription subscription = (MQTTSubscription)this.mqttSubscriptionByTopic.remove(topicName);
        if (subscription != null) {
            this.doUnSubscribe(subscription);
            if (subscription.getDestination().isQueue()) {
                DestinationInfo remove2 = new DestinationInfo();
                remove2.setConnectionId(this.protocol.getConnectionId());
                remove2.setDestination(subscription.getDestination());
                remove2.setOperationType((byte)1);
                this.protocol.sendToActiveMQ(remove2, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            } else if (subscription.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredDurableSubs.remove(MQTTProtocolSupport.convertMQTTToActiveMQ(subscription.getTopicName()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(subscription.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.protocol.getClientId());
                this.protocol.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
    }

    @Override
    public ActiveMQDestination onSend(String topicName) {
        if (!topicName.startsWith(VIRTUALTOPIC_PREFIX)) {
            return new ActiveMQTopic(VIRTUALTOPIC_PREFIX + topicName);
        }
        return new ActiveMQTopic(topicName);
    }

    @Override
    public String onSend(ActiveMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        int position = destinationName.indexOf(VIRTUALTOPIC_PREFIX);
        if (position >= 0) {
            destinationName = destinationName.substring(position + VIRTUALTOPIC_PREFIX.length()).substring(0);
        }
        return destinationName;
    }

    @Override
    public boolean isControlTopic(ActiveMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        return destinationName.startsWith("$") || destinationName.startsWith("VirtualTopic.$");
    }

    private void deleteDurableQueues(List<ActiveMQQueue> queues) {
        try {
            for (ActiveMQQueue queue2 : queues) {
                LOG.debug("Removing queue subscription for {} ", (Object)queue2.getPhysicalName());
                DestinationInfo removeAction = new DestinationInfo();
                removeAction.setConnectionId(this.protocol.getConnectionId());
                removeAction.setDestination(queue2);
                removeAction.setOperationType((byte)1);
                this.protocol.sendToActiveMQ(removeAction, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT queue subsscriptions.", e);
        }
    }

    private void restoreDurableQueue(List<ActiveMQQueue> queues) {
        try {
            for (ActiveMQQueue queue2 : queues) {
                String name = queue2.getPhysicalName().substring(VIRTUALTOPIC_CONSUMER_PREFIX.length());
                StringTokenizer tokenizer = new StringTokenizer(name);
                tokenizer.nextToken(":.");
                String qosString = tokenizer.nextToken();
                tokenizer.nextToken();
                String topicName = MQTTProtocolSupport.convertActiveMQToMQTT(tokenizer.nextToken("").substring(1));
                QoS qoS = QoS.valueOf(qosString);
                LOG.trace("Restoring queue subscription: {}:{}", (Object)topicName, (Object)qoS);
                ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
                consumerInfo.setDestination(queue2);
                consumerInfo.setPrefetchSize(1000);
                if (this.protocol.getActiveMQSubscriptionPrefetch() > 0) {
                    consumerInfo.setPrefetchSize(this.protocol.getActiveMQSubscriptionPrefetch());
                }
                consumerInfo.setRetroactive(true);
                consumerInfo.setDispatchAsync(true);
                this.doSubscribe(consumerInfo, topicName, qoS);
                this.restoredQueues.add(queue2);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT queue subscriptions.", (Throwable)e);
        }
    }

    List<ActiveMQQueue> lookupQueues(String clientId) throws MQTTProtocolException {
        RegionBroker regionBroker;
        ArrayList<ActiveMQQueue> result = new ArrayList<ActiveMQQueue>();
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error recovering queues: " + e.getMessage(), false, e);
        }
        QueueRegion queueRegion = (QueueRegion)regionBroker.getQueueRegion();
        for (ActiveMQDestination destination : queueRegion.getDestinationMap().keySet()) {
            if (!destination.isQueue() || destination.isTemporary() || !destination.getPhysicalName().startsWith(VIRTUALTOPIC_CONSUMER_PREFIX + clientId)) continue;
            LOG.debug("Recovered client sub: {} on connect", (Object)destination.getPhysicalName());
            result.add((ActiveMQQueue)destination);
        }
        return result;
    }
}

