/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

public class MQTTProtocolSupport {
    public static String convertMQTTToActiveMQ(String name) {
        char[] chars = name.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public static String convertActiveMQToMQTT(String destinationName) {
        char[] chars = destinationName.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public static String commandType(byte header) {
        byte messageType = (byte)((header & 0xF0) >>> 4);
        switch (messageType) {
            case 12: {
                return "PINGREQ";
            }
            case 1: {
                return "CONNECT";
            }
            case 14: {
                return "DISCONNECT";
            }
            case 8: {
                return "SUBSCRIBE";
            }
            case 10: {
                return "UNSUBSCRIBE";
            }
            case 3: {
                return "PUBLISH";
            }
            case 4: {
                return "PUBACK";
            }
            case 5: {
                return "PUBREC";
            }
            case 6: {
                return "PUBREL";
            }
            case 7: {
                return "PUBCOMP";
            }
        }
        return "UNKNOWN";
    }
}

