/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.PropertiesLoader;
import org.apache.activemq.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoginModule
extends PropertiesLoader
implements LoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.user";
    private static final String GROUP_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.group";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Properties users;
    private Properties groups;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private boolean loginSucceeded;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.loginSucceeded = false;
        this.init(options);
        this.users = this.load(USER_FILE_PROP_NAME, "user", options).getProps();
        this.groups = this.load(GROUP_FILE_PROP_NAME, "group", options).getProps();
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            throw new FailedLoginException("user name is null");
        }
        String password = this.users.getProperty(this.user);
        if (password == null) {
            throw new FailedLoginException("User does exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.loginSucceeded = true;
        if (this.debug) {
            LOG.debug("login " + this.user);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.user));
            block0: for (Map.Entry<Object, Object> entry : this.groups.entrySet()) {
                String name = (String)entry.getKey();
                String[] userList = ((String)entry.getValue()).split(",");
                for (int i = 0; i < userList.length; ++i) {
                    if (!this.user.equals(userList[i])) continue;
                    this.principals.add(new GroupPrincipal(name));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        if (this.debug) {
            LOG.debug("commit, result: " + result);
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }
}

