/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce.lib;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.ConfiguratorBase;
import org.apache.hadoop.conf.Configuration;

public class OutputConfigurator
extends ConfiguratorBase {
    public static void setDefaultTableName(Class<?> implementingClass, Configuration conf, String tableName) {
        if (tableName != null) {
            conf.set(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.DEFAULT_TABLE_NAME), tableName);
        }
    }

    public static String getDefaultTableName(Class<?> implementingClass, Configuration conf) {
        return conf.get(OutputConfigurator.enumToConfKey(implementingClass, WriteOpts.DEFAULT_TABLE_NAME));
    }

    public static BatchWriterConfig getBatchWriterOptions(Class<?> implementingClass, Configuration conf) {
        Integer intValue;
        Long value;
        BatchWriterConfig bwConfig = new BatchWriterConfig();
        Properties props = OutputConfigurator.getClientProperties(implementingClass, conf);
        String property = props.getProperty(ClientProperty.BATCH_WRITER_DURABILITY.getKey());
        if (property != null) {
            bwConfig.setDurability(DurabilityImpl.fromString((String)property));
        }
        if ((value = ClientProperty.BATCH_WRITER_LATENCY_MAX.getTimeInMillis(props)) != null) {
            bwConfig.setMaxLatency(value.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((value = ClientProperty.BATCH_WRITER_MEMORY_MAX.getBytes(props)) != null) {
            bwConfig.setMaxMemory(value.longValue());
        }
        if ((value = ClientProperty.BATCH_WRITER_TIMEOUT_MAX.getTimeInMillis(props)) != null) {
            bwConfig.setTimeout(value.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((intValue = ClientProperty.BATCH_WRITER_THREADS_MAX.getInteger(props)) != null) {
            bwConfig.setMaxWriteThreads(intValue.intValue());
        }
        return bwConfig;
    }

    public static void setCreateTables(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.CAN_CREATE_TABLES), enableFeature);
    }

    public static Boolean canCreateTables(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.CAN_CREATE_TABLES), false);
    }

    public static void setSimulationMode(Class<?> implementingClass, Configuration conf, boolean enableFeature) {
        conf.setBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.SIMULATION_MODE), enableFeature);
    }

    public static Boolean getSimulationMode(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(OutputConfigurator.enumToConfKey(implementingClass, Features.SIMULATION_MODE), false);
    }

    public static enum Features {
        CAN_CREATE_TABLES,
        SIMULATION_MODE;

    }

    public static enum WriteOpts {
        DEFAULT_TABLE_NAME,
        BATCH_WRITER_CONFIG;

    }
}

