/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.hadoopImpl.mapreduce.SplitUtils;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.InputConfigurator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class RangeInputSplit
extends InputSplit
implements Writable {
    private Range range;
    private String[] locations;
    private String tableId;
    private String tableName;
    private Boolean offline;
    private Boolean isolatedScan;
    private Boolean localIterators;
    private Set<IteratorSetting.Column> fetchedColumns;
    private List<IteratorSetting> iterators;
    private SamplerConfiguration samplerConfig;
    private Map<String, String> executionHints;

    public RangeInputSplit() {
        this.range = new Range();
        this.locations = new String[0];
        this.tableName = "";
        this.tableId = "";
    }

    public RangeInputSplit(RangeInputSplit split) throws IOException {
        this.range = split.getRange();
        this.setLocations(split.getLocations());
        this.setTableName(split.getTableName());
        this.setTableId(split.getTableId());
    }

    public RangeInputSplit(String table, String tableId, Range range, String[] locations) {
        this.range = range;
        this.setLocations(locations);
        this.tableName = table;
        this.tableId = tableId;
    }

    public Range getRange() {
        return this.range;
    }

    public static float getProgress(ByteSequence start, ByteSequence end, ByteSequence position) {
        return SplitUtils.getProgress(start, end, position);
    }

    public float getProgress(Key currentKey) {
        if (currentKey == null) {
            return 0.0f;
        }
        if (this.range.contains(currentKey) && this.range.getStartKey() != null && this.range.getEndKey() != null) {
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getRowData(), this.range.getEndKey().getRowData(), currentKey.getRowData());
            }
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW_COLFAM) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getColumnFamilyData(), this.range.getEndKey().getColumnFamilyData(), currentKey.getColumnFamilyData());
            }
            if (this.range.getStartKey().compareTo(this.range.getEndKey(), PartialKey.ROW_COLFAM_COLQUAL) != 0) {
                return RangeInputSplit.getProgress(this.range.getStartKey().getColumnQualifierData(), this.range.getEndKey().getColumnQualifierData(), currentKey.getColumnQualifierData());
            }
        }
        return 0.0f;
    }

    public long getLength() throws IOException {
        return SplitUtils.getRangeLength(this.range);
    }

    public String[] getLocations() {
        return Arrays.copyOf(this.locations, this.locations.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.range.readFields(in);
        this.tableName = in.readUTF();
        this.tableId = in.readUTF();
        int numLocs = in.readInt();
        this.locations = new String[numLocs];
        for (int i = 0; i < numLocs; ++i) {
            this.locations[i] = in.readUTF();
        }
        if (in.readBoolean()) {
            this.isolatedScan = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.offline = in.readBoolean();
        }
        if (in.readBoolean()) {
            this.localIterators = in.readBoolean();
        }
        if (in.readBoolean()) {
            int numColumns = in.readInt();
            ArrayList<String> columns = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                columns.add(in.readUTF());
            }
            this.fetchedColumns = InputConfigurator.deserializeFetchedColumns(columns);
        }
        if (in.readBoolean()) {
            int numIterators = in.readInt();
            this.iterators = new ArrayList<IteratorSetting>(numIterators);
            for (int i = 0; i < numIterators; ++i) {
                this.iterators.add(new IteratorSetting(in));
            }
        }
        if (in.readBoolean()) {
            this.samplerConfig = new SamplerConfigurationImpl(in).toSamplerConfiguration();
        }
        this.executionHints = new HashMap<String, String>();
        int numHints = in.readInt();
        for (int i = 0; i < numHints; ++i) {
            String k = in.readUTF();
            String v = in.readUTF();
            this.executionHints.put(k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.range.write(out);
        out.writeUTF(this.tableName);
        out.writeUTF(this.tableId);
        out.writeInt(this.locations.length);
        for (String location : this.locations) {
            out.writeUTF(location);
        }
        out.writeBoolean(this.isolatedScan != null);
        if (this.isolatedScan != null) {
            out.writeBoolean(this.isolatedScan);
        }
        out.writeBoolean(this.offline != null);
        if (this.offline != null) {
            out.writeBoolean(this.offline);
        }
        out.writeBoolean(this.localIterators != null);
        if (this.localIterators != null) {
            out.writeBoolean(this.localIterators);
        }
        out.writeBoolean(this.fetchedColumns != null);
        if (this.fetchedColumns != null) {
            String[] cols = InputConfigurator.serializeColumns(this.fetchedColumns);
            out.writeInt(cols.length);
            for (String col : cols) {
                out.writeUTF(col);
            }
        }
        out.writeBoolean(this.iterators != null);
        if (this.iterators != null) {
            out.writeInt(this.iterators.size());
            for (IteratorSetting iteratorSetting : this.iterators) {
                iteratorSetting.write(out);
            }
        }
        out.writeBoolean(this.samplerConfig != null);
        if (this.samplerConfig != null) {
            new SamplerConfigurationImpl(this.samplerConfig).write(out);
        }
        if (this.executionHints == null || this.executionHints.size() == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.executionHints.size());
            for (Map.Entry entry : this.executionHints.entrySet()) {
                out.writeUTF((String)entry.getKey());
                out.writeUTF((String)entry.getValue());
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public Boolean isOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public void setLocations(String[] locations) {
        this.locations = Arrays.copyOf(locations, locations.length);
    }

    public Boolean isIsolatedScan() {
        return this.isolatedScan;
    }

    public void setIsolatedScan(Boolean isolatedScan) {
        this.isolatedScan = isolatedScan;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Boolean usesLocalIterators() {
        return this.localIterators;
    }

    public void setUsesLocalIterators(Boolean localIterators) {
        this.localIterators = localIterators;
    }

    public Set<IteratorSetting.Column> getFetchedColumns() {
        return this.fetchedColumns;
    }

    public void setFetchedColumns(Collection<IteratorSetting.Column> fetchedColumns) {
        this.fetchedColumns = new HashSet<IteratorSetting.Column>();
        for (IteratorSetting.Column columns : fetchedColumns) {
            this.fetchedColumns.add(columns);
        }
    }

    public void setFetchedColumns(Set<IteratorSetting.Column> fetchedColumns) {
        this.fetchedColumns = fetchedColumns;
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public void setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Range: ").append(this.range);
        sb.append(" Locations: ").append(Arrays.asList(this.locations));
        sb.append(" Table: ").append(this.tableName);
        sb.append(" TableID: ").append(this.tableId);
        sb.append(" offlineScan: ").append(this.offline);
        sb.append(" isolatedScan: ").append(this.isolatedScan);
        sb.append(" localIterators: ").append(this.localIterators);
        sb.append(" fetchColumns: ").append(this.fetchedColumns);
        sb.append(" iterators: ").append(this.iterators);
        sb.append(" samplerConfig: ").append(this.samplerConfig);
        sb.append(" executionHints: ").append(this.executionHints);
        return sb.toString();
    }

    public void setSamplerConfiguration(SamplerConfiguration samplerConfiguration) {
        this.samplerConfig = samplerConfiguration;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        return this.samplerConfig;
    }

    public void setExecutionHints(Map<String, String> executionHints) {
        this.executionHints = executionHints;
    }

    public Map<String, String> getExecutionHints() {
        return this.executionHints;
    }
}

