/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import org.activiti.engine.IdentityService;
import org.activiti.spring.security.IdentityServiceUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration
@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration.class})
public class SecurityAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={UserDetailsService.class})
    public static class UserDetailsServiceConfiguration
    extends GlobalAuthenticationConfigurerAdapter {
        @Autowired
        private IdentityService identityService;

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            auth.userDetailsService(this.userDetailsService());
        }

        @Bean
        public UserDetailsService userDetailsService() {
            return new IdentityServiceUserDetailsService(this.identityService);
        }
    }
}

