/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.data.storage;

import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.AccountImpl;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.data.storage.AccountRepositoryHolderMBean;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class AccountRepositoryHolderImpl
extends AbstractLogEnabled
implements AccountRepositoryHolder,
AccountRepositoryHolderMBean,
Serviceable,
Configurable,
Initializable,
ThreadSafe {
    private ServiceManager m_serviceManager;
    private DirContext m_dirContext;
    private Hashtable m_confEnv;
    private String m_lookupDir;
    private String m_attribSearch;
    private String m_ldapPasswordAttribute;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_confEnv = new Hashtable();
        String initCtxFactory = configuration.getChild("initial-context-factory").getValue();
        if (initCtxFactory != null) {
            this.m_confEnv.put("java.naming.factory.initial", initCtxFactory);
        }
        String securityAuthentication = configuration.getChild("security-authentication").getValue("simple");
        this.m_confEnv.put("java.naming.security.authentication", securityAuthentication);
        String providerUrl = configuration.getChild("provider-url").getValue(null);
        if (providerUrl != null) {
            this.m_confEnv.put("java.naming.provider.url", providerUrl);
        }
        String securityPrincipal = configuration.getChild("security-principal").getValue(null);
        String securityCredentials = configuration.getChild("security-credentials").getValue(null);
        if (securityPrincipal != null && securityCredentials != null) {
            this.m_confEnv.put("java.naming.security.principal", securityPrincipal);
            this.m_confEnv.put("java.naming.security.credentials", securityCredentials);
        }
        this.m_lookupDir = configuration.getChild("ldap-lookup-directory").getValue();
        this.m_attribSearch = configuration.getChild("ldap-attribute-search").getValue();
        this.m_ldapPasswordAttribute = configuration.getChild("ldap-password-attribute").getValue();
    }

    public void initialize() throws Exception {
        this.m_dirContext = new InitialDirContext(this.m_confEnv);
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public Account getAccount(String username) {
        this.getLogger().debug("Get username " + username + " account");
        AccountImpl account = null;
        try {
            DirContext context = (DirContext)this.m_dirContext.lookup(this.m_lookupDir);
            NamingEnumeration<SearchResult> ne = context.search("", (Attributes)new BasicAttributes(this.m_attribSearch, username));
            SearchResult sr = (SearchResult)ne.nextElement();
            Attributes attr = sr.getAttributes();
            Attribute passwordAttrib = attr.get(this.m_ldapPasswordAttribute);
            account = new AccountImpl();
            account.setName(username);
            Object value = passwordAttrib.get();
            if (value instanceof byte[]) {
                account.setPassword(new String((byte[])value));
            } else {
                account.setPassword(value.toString());
            }
        }
        catch (Exception e) {
            this.getLogger().debug(e.getMessage(), (Throwable)e);
            this.getLogger().warn("User " + username + " not found");
        }
        return account;
    }

    public List getAccountList(String searchPattern) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Account removeAccount(String username) {
        throw new UnsupportedOperationException("Not implemented (LDAP read only access)");
    }

    public void setAccount(Account account) {
        throw new UnsupportedOperationException("Not implemented (LDAP read only access)");
    }

    public void setAccount(String accountStr) {
        throw new UnsupportedOperationException("Not implemented (LDAP read only access)");
    }

    public List getAccountList() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

