/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restservice.sparkjava.types;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.LongSerializationPolicy;
import java.lang.reflect.Type;
import java.util.Date;
import one.microstream.storage.restadapter.types.StorageViewDataConverter;

public class StorageViewDataConverterJson
implements StorageViewDataConverter {
    private static final String HTML_RESPONCE_CONTENT_TYPE = "application/json";
    private static final String[] FORMAT_STRINGS = new String[]{"application/json", "json"};
    private final Gson gson;

    public StorageViewDataConverterJson() {
        JsonSerializer<Date> serializerDate = new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toInstant().toString());
            }
        };
        this.gson = new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).serializeNulls().registerTypeAdapter(Date.class, (Object)serializerDate).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public String convert(Object object) {
        return this.gson.toJson(object);
    }

    public String getHtmlResponseContentType() {
        return HTML_RESPONCE_CONTENT_TYPE;
    }

    public String[] getFormatStrings() {
        return FORMAT_STRINGS;
    }
}

