/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restservice.sparkjava.types;

import one.microstream.X;
import one.microstream.storage.restadapter.exceptions.StorageRestAdapterException;
import one.microstream.storage.restadapter.types.StorageRestAdapter;
import one.microstream.storage.restadapter.types.StorageRestAdapterObject;
import one.microstream.storage.restadapter.types.StorageRestAdapterRoot;
import one.microstream.storage.restadapter.types.StorageRestAdapterStorageInfo;
import one.microstream.storage.restadapter.types.StorageRestAdapterTypeDictionary;
import one.microstream.storage.restservice.sparkjava.exceptions.InvalidRouteParametersException;
import one.microstream.storage.restservice.sparkjava.types.DocumentationManager;
import one.microstream.storage.restservice.sparkjava.types.RouteAllRoutes;
import one.microstream.storage.restservice.sparkjava.types.RouteGetObject;
import one.microstream.storage.restservice.sparkjava.types.RouteGetRoot;
import one.microstream.storage.restservice.sparkjava.types.RouteManager;
import one.microstream.storage.restservice.sparkjava.types.RouteStorageFilesStatistics;
import one.microstream.storage.restservice.sparkjava.types.RouteTypeDictionary;
import one.microstream.storage.restservice.types.StorageRestService;
import one.microstream.storage.types.StorageManager;
import spark.Service;
import spark.route.HttpMethod;

public class StorageRestServiceSparkJava
implements StorageRestService {
    private final StorageRestAdapter storageRestAdapter;
    private Service sparkService;
    private String storageName = "microstream";
    private RouteManager routeManager;

    public static StorageRestServiceSparkJava New(StorageManager storage) {
        return new StorageRestServiceSparkJava(StorageRestAdapter.New((StorageManager)storage));
    }

    public static StorageRestServiceSparkJava New(StorageRestAdapter storageRestAdapter) {
        return new StorageRestServiceSparkJava((StorageRestAdapter)X.notNull((Object)storageRestAdapter));
    }

    StorageRestServiceSparkJava(StorageRestAdapter storageRestAdapter) {
        this.storageRestAdapter = storageRestAdapter;
    }

    public void setInstanceName(String name) {
        this.storageName = name;
    }

    public void setSparkService(Service sparkService) {
        this.sparkService = sparkService;
    }

    public void setDefaultDataLength(long defaultDataLength) {
        this.storageRestAdapter.setDefaultValueLength(defaultDataLength);
    }

    public void start() {
        if (this.sparkService == null) {
            this.sparkService = Service.ignite();
        }
        this.setupRoutes();
        this.sparkService.init();
        this.sparkService.awaitInitialization();
    }

    private void setupRoutes() {
        this.routeManager = new DocumentationManager(this.sparkService);
        this.routeManager.registerRoute(HttpMethod.get, "/", new RouteAllRoutes((DocumentationManager)this.routeManager));
        this.routeManager.registerRoute(HttpMethod.get, "/" + this.storageName + "/root", new RouteGetRoot((StorageRestAdapterRoot)this.storageRestAdapter));
        this.routeManager.registerRoute(HttpMethod.get, "/" + this.storageName + "/dictionary", new RouteTypeDictionary((StorageRestAdapterTypeDictionary)this.storageRestAdapter));
        this.routeManager.registerRoute(HttpMethod.get, "/" + this.storageName + "/object/:oid", new RouteGetObject((StorageRestAdapterObject)this.storageRestAdapter));
        this.routeManager.registerRoute(HttpMethod.get, "/" + this.storageName + "/maintenance/filesStatistics", new RouteStorageFilesStatistics((StorageRestAdapterStorageInfo)this.storageRestAdapter));
        this.sparkService.exception(InvalidRouteParametersException.class, (e, request, response) -> {
            response.status(404);
            response.body(e.getMessage());
        });
        this.sparkService.exception(StorageRestAdapterException.class, (e, request, response) -> {
            response.status(404);
            response.body(e.getMessage());
        });
    }

    public void stop() {
        if (this.sparkService != null) {
            this.sparkService.stop();
            this.sparkService.awaitStop();
        }
    }
}

