/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restservice.sparkjava.types;

import java.util.Hashtable;
import one.microstream.storage.restservice.sparkjava.types.RouteBase;
import spark.RouteImpl;
import spark.Service;
import spark.route.HttpMethod;

public class RouteManager {
    protected final Service sparkService;
    private final Hashtable<String, Hashtable<String, String>> registeredRoutes;

    public RouteManager(Service sparkService) {
        this.sparkService = sparkService;
        this.registeredRoutes = new Hashtable();
    }

    public Hashtable<String, Hashtable<String, String>> getRegisteredRoutes() {
        return this.registeredRoutes;
    }

    public void registerRoute(HttpMethod httpMethod, String uri, RouteBase<?> route) {
        Hashtable<String, String> methods = this.registeredRoutes.get(uri);
        if (methods == null) {
            methods = new Hashtable();
            this.registeredRoutes.put(uri, methods);
        }
        methods.put(httpMethod.toString().toLowerCase(), route.getClass().getName());
        this.sparkService.addRoute(httpMethod, RouteImpl.create((String)uri, route));
    }
}

