/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restservice.sparkjava.types;

import one.microstream.storage.restservice.sparkjava.exceptions.InvalidRouteParametersException;
import spark.Request;
import spark.Route;

public abstract class RouteBase<T>
implements Route {
    protected final T apiAdapter;

    public RouteBase(T apiAdapter) {
        this.apiAdapter = apiAdapter;
    }

    protected boolean getBooleanParameter(Request request, String name, boolean defaultValue) {
        String param = request.queryParams(name);
        if (param == null) {
            return defaultValue;
        }
        if (param.toLowerCase().contentEquals("true") || param.toLowerCase().contentEquals("false")) {
            return Boolean.parseBoolean(param);
        }
        throw new InvalidRouteParametersException(name);
    }

    protected long getLongParameter(Request request, String name, long defaultValue) {
        String param = request.queryParams(name);
        if (param == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            throw new InvalidRouteParametersException(name);
        }
    }

    protected String getStringParameter(Request request, String name) {
        return request.queryParams(name);
    }

    protected long validateObjectId(Request request) {
        try {
            return Long.parseLong(request.params(":oid"));
        }
        catch (NumberFormatException e) {
            throw new InvalidRouteParametersException("ObjectId");
        }
    }

    protected double getDoubleParameter(Request request, String name, double defaultValue) {
        String param = request.queryParams(name);
        if (param == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(param);
        }
        catch (NumberFormatException e) {
            throw new InvalidRouteParametersException(name);
        }
    }

    protected int getIntParameter(Request request, String name, int defaultValue) {
        String param = request.queryParams(name);
        if (param == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new InvalidRouteParametersException(name);
        }
    }
}

