/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restservice.sparkjava.types;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Set;
import one.microstream.storage.restadapter.exceptions.StorageRestAdapterException;
import one.microstream.storage.restservice.sparkjava.types.RouteBase;
import one.microstream.storage.restservice.sparkjava.types.RouteDocumentation;
import one.microstream.storage.restservice.sparkjava.types.RouteManager;
import spark.Route;
import spark.RouteImpl;
import spark.Service;
import spark.route.HttpMethod;

public class DocumentationManager
extends RouteManager {
    private final Hashtable<String, Hashtable<String, JsonElement>> documentations = new Hashtable();

    public DocumentationManager(Service sparkService) {
        super(sparkService);
        this.buildLiveDocumentation("/doc.json");
    }

    @Override
    public void registerRoute(HttpMethod httpMethod, String uri, RouteBase<?> route) {
        super.registerRoute(httpMethod, uri, route);
        Hashtable<String, String> methods = this.getRegisteredRoutes().get(uri);
        methods.put(HttpMethod.options.toString().toLowerCase(), route.getClass().getName());
        this.sparkService.addRoute(HttpMethod.options, RouteImpl.create((String)uri, (Route)new RouteDocumentation(this)));
    }

    public Object getAllRoutes(String host) {
        JsonArray routesJson = new JsonArray(this.getRegisteredRoutes().size());
        this.getRegisteredRoutes().forEach((path, methods) -> {
            JsonObject route = new JsonObject();
            route.addProperty("URL", String.valueOf(host) + path);
            JsonArray methodsJson = new JsonArray(methods.size());
            route.add("HttpMethod", (JsonElement)methodsJson);
            methods.forEach((method, handler) -> methodsJson.add(method.toString()));
            routesJson.add((JsonElement)route);
        });
        return routesJson;
    }

    public Object getDocumentation(String uri, String httpMethod) {
        try {
            String handler = this.getRegisteredRoutes().get(uri).get(httpMethod);
            return this.documentations.get(handler).get(httpMethod);
        }
        catch (Exception e) {
            throw new StorageRestAdapterException("No documentation found");
        }
    }

    public Object getDocumentation(String uri) {
        Hashtable<String, String> UriMethods = this.getRegisteredRoutes().get(uri);
        if (UriMethods == null) {
            throw new StorageRestAdapterException("No documentation found");
        }
        JsonObject docu = new JsonObject();
        UriMethods.forEach((httpMethod, handlerName) -> docu.add(httpMethod, this.documentations.get(handlerName).get(httpMethod)));
        return docu;
    }

    private void buildLiveDocumentation(String filePath) {
        JsonObject doc;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filePath)));){
                doc = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new StorageRestAdapterException((Throwable)e);
        }
        JsonObject handlers = doc.getAsJsonObject("handler");
        handlers.entrySet().forEach(handler -> {
            Hashtable<String, Object> handlerMethods = this.documentations.get(handler.getKey());
            if (handlerMethods == null) {
                handlerMethods = new Hashtable();
                this.documentations.put((String)handler.getKey(), handlerMethods);
            }
            JsonObject methods = ((JsonElement)handler.getValue()).getAsJsonObject();
            Set key = methods.keySet();
            for (String string : key) {
                handlerMethods.put(string, methods.get(string));
            }
        });
    }
}

