/*
 * Decompiled with CFR 0.152.
 */
package net.zhfish.tio.autoconfigure;

import java.io.IOException;
import net.zhfish.tio.annotation.EnableTioWebsocketConfiguration;
import net.zhfish.tio.bean.TioWebsocketManager;
import net.zhfish.tio.bean.TioWebsocketMsgHandler;
import net.zhfish.tio.utils.TioProps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={TioWebsocketManager.class})
@ConditionalOnBean(annotation={EnableTioWebsocketConfiguration.class})
@EnableConfigurationProperties(value={TioProps.class})
public class TioWebsocketAutoConfiguration {
    public static final String MANAGER_BEAN_NAME = "TioWebsocketManager";
    @Autowired
    private TioProps tioProps;

    @Bean
    @ConditionalOnMissingBean(value={TioWebsocketManager.class})
    public TioWebsocketManager tioWebsocketBean() throws IOException {
        return new TioWebsocketManager(this.tioProps.getWebsocket(), this.tioWebsocketMsgBean());
    }

    @Bean
    @ConditionalOnMissingBean(value={TioWebsocketMsgHandler.class})
    public TioWebsocketMsgHandler tioWebsocketMsgBean() {
        return new TioWebsocketMsgHandler();
    }
}

