/*
 * Decompiled with CFR 0.152.
 */
package net.zhfish.tio.bean;

import net.zhfish.tio.bean.TioWebSocketMethods;
import net.zhfish.tio.bean.TioWebsocketMethodMapper;
import net.zhfish.tio.bean.TioWebsocketRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class TioWebsocketMsgHandler
implements IWsMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(TioWebsocketMsgHandler.class);
    private TioWebSocketMethods methods;

    public HttpResponse handshake(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        String clientip = httpRequest.getClientIp();
        log.debug("receive {}'s websocket handshake packet \r\n{}", (Object)clientip, (Object)httpRequest.toString());
        TioWebsocketMethodMapper handshake = this.methods.getHandshake();
        if (handshake != null) {
            handshake.getMethod().invoke(handshake.getInstance(), httpRequest, httpResponse, channelContext);
        }
        return httpResponse;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        log.debug("onAfterHandshaked");
        TioWebsocketMethodMapper onAfterHandshaked = this.methods.getOnAfterHandshaked();
        if (onAfterHandshaked != null) {
            onAfterHandshaked.getMethod().invoke(onAfterHandshaked.getInstance(), httpRequest, httpResponse, channelContext);
        }
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        TioWebsocketMethodMapper onClose = this.methods.getOnClose();
        if (onClose != null) {
            onClose.getMethod().invoke(onClose.getInstance(), channelContext);
        }
        log.debug("onClose");
        Tio.remove((ChannelContext)channelContext, (String)"onClose");
        return null;
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        log.debug("onBytes");
        TioWebsocketMethodMapper onBytes = this.methods.getOnBytes();
        if (onBytes != null) {
            onBytes.getMethod().invoke(onBytes.getInstance(), channelContext, bytes);
        } else {
            TioWebsocketMethodMapper onBeforeBytes = this.methods.getOnBeforeBytes();
            if (onBeforeBytes != null) {
                TioWebsocketRequest invoke = (TioWebsocketRequest)onBeforeBytes.getMethod().invoke(onBeforeBytes.getInstance(), channelContext, bytes);
                this.onMapEvent(invoke, channelContext);
            }
        }
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) throws Exception {
        log.debug("onText");
        TioWebsocketMethodMapper onText = this.methods.getOnText();
        if (onText != null) {
            onText.getMethod().invoke(onText.getInstance(), channelContext, text);
        } else {
            TioWebsocketMethodMapper onBeforeText = this.methods.getOnBeforeText();
            if (onBeforeText != null) {
                TioWebsocketRequest invoke = (TioWebsocketRequest)onBeforeText.getMethod().invoke(onBeforeText.getInstance(), channelContext, text);
                this.onMapEvent(invoke, channelContext);
            }
        }
        return null;
    }

    private void onMapEvent(TioWebsocketRequest request, ChannelContext channelContext) throws Exception {
        if (request != null && !StringUtils.isEmpty((Object)request.getEvent())) {
            TioWebsocketMethodMapper methodMapper = this.methods.getOnMapEvent().get(request.getEvent());
            if (methodMapper != null) {
                methodMapper.getMethod().invoke(methodMapper.getInstance(), channelContext, request.getObject());
            } else {
                TioWebsocketMethodMapper onMap = this.methods.getOnMap();
                if (onMap != null) {
                    onMap.getMethod().invoke(onMap.getInstance(), channelContext, request.getEvent(), request.getObject());
                }
            }
        }
    }

    public void setMethods(TioWebSocketMethods methods) {
        this.methods = methods;
    }
}

