/*
 * Decompiled with CFR 0.152.
 */
package net.zhfish.tio.bean;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import net.zhfish.tio.annotation.TIOnAfterHandshake;
import net.zhfish.tio.annotation.TIOnBeforeBytes;
import net.zhfish.tio.annotation.TIOnBeforeText;
import net.zhfish.tio.annotation.TIOnBytes;
import net.zhfish.tio.annotation.TIOnClose;
import net.zhfish.tio.annotation.TIOnHandshake;
import net.zhfish.tio.annotation.TIOnMap;
import net.zhfish.tio.annotation.TIOnText;
import net.zhfish.tio.annotation.TioController;
import net.zhfish.tio.bean.TioWebSocketMethods;
import net.zhfish.tio.bean.TioWebsocketMethodMapper;
import net.zhfish.tio.bean.TioWebsocketMsgHandler;
import net.zhfish.tio.bean.TioWebsocketRequest;
import net.zhfish.tio.exception.TioWebsocketException;
import net.zhfish.tio.utils.TioProps;
import net.zhfish.tio.utils.TioWebsocketUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.tio.core.ChannelContext;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.server.ServerGroupContext;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.WsServerStarter;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class TioWebsocketManager
extends ApplicationObjectSupport
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(TioWebsocketManager.class);
    private final WsServerStarter starter;
    private final TioWebSocketMethods methods;
    private final ServerGroupContext groupContext;

    public TioWebsocketManager(TioProps.Websocket config, IWsMsgHandler wsMsgHandler) throws IOException {
        if (!config.getEnable().booleanValue()) {
            this.starter = null;
            this.groupContext = null;
            this.methods = null;
            return;
        }
        WsServerConfig wsConfig = new WsServerConfig(config.getPort());
        wsConfig.setBindIp(config.getIp());
        wsConfig.setCharset(config.getCharset());
        this.starter = new WsServerStarter(wsConfig, wsMsgHandler);
        this.groupContext = this.starter.getServerGroupContext();
        this.groupContext.setName(config.getProtocalName());
        this.groupContext.setHeartbeatTimeout((long)config.getHeartbeatTimeout().intValue());
        this.methods = new TioWebSocketMethods();
    }

    public void afterSingletonsInstantiated() {
        if (this.starter == null) {
            return;
        }
        this.init();
        try {
            this.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("websocket start failed");
        }
    }

    private void init() {
        String[] neanNames;
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        ApplicationContext context = this.getApplicationContext();
        if (context == null) {
            return;
        }
        TioWebsocketUtil.putManager(this);
        for (String beanName : neanNames = context.getBeanNamesForAnnotation(TioController.class)) {
            classes.add(context.getType(beanName));
        }
        classes.forEach(item -> {
            Method[] currentClazzMethods = item.getDeclaredMethods();
            Object bean = context.getBean(item);
            for (Method method : currentClazzMethods) {
                Class<?>[] parameterTypes;
                Class<?> returnType;
                Class<?>[] parameterTypes2;
                Class<?> returnType2;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                if (method.isAnnotationPresent(TIOnHandshake.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(Void.TYPE) || (parameterTypes2 = method.getParameterTypes()).length != 3 || !parameterTypes2[0].equals(HttpRequest.class) || !parameterTypes2[1].equals(HttpResponse.class) || !parameterTypes2[2].equals(ChannelContext.class)) continue;
                    if (this.methods.getHandshake() != null) {
                        throw new TioWebsocketException("duplicate TIOnHandshake");
                    }
                    this.methods.setHandshake(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnAfterHandshake.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(Void.TYPE) || (parameterTypes2 = method.getParameterTypes()).length != 3 || !parameterTypes2[0].equals(HttpRequest.class) || !parameterTypes2[1].equals(HttpResponse.class) || !parameterTypes2[2].equals(ChannelContext.class)) continue;
                    if (this.methods.getOnAfterHandshaked() != null) {
                        throw new TioWebsocketException("duplicate TIOnAfterHandshake");
                    }
                    this.methods.setOnAfterHandshaked(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnClose.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(Void.TYPE) || (parameterTypes2 = method.getParameterTypes()).length != 1 || !parameterTypes2[0].equals(ChannelContext.class)) continue;
                    if (this.methods.getOnClose() != null) {
                        throw new TioWebsocketException("duplicate TIOnClose");
                    }
                    this.methods.setOnClose(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnBeforeBytes.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(TioWebsocketRequest.class) || (parameterTypes2 = method.getParameterTypes()).length != 2 || !parameterTypes2[0].equals(ChannelContext.class) || !parameterTypes2[1].equals(byte[].class)) continue;
                    if (this.methods.getOnBeforeBytes() != null) {
                        throw new TioWebsocketException("duplicate TIOnBeforeBytes");
                    }
                    this.methods.setOnBeforeBytes(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnBeforeText.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(TioWebsocketRequest.class) || (parameterTypes2 = method.getParameterTypes()).length != 2 || !parameterTypes2[0].equals(ChannelContext.class) || !parameterTypes2[1].equals(String.class)) continue;
                    if (this.methods.getOnBeforeText() != null) {
                        throw new TioWebsocketException("duplicate TIOnBeforeText");
                    }
                    this.methods.setOnBeforeText(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnText.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(Void.TYPE) || (parameterTypes2 = method.getParameterTypes()).length != 2 || !parameterTypes2[0].equals(ChannelContext.class) || !parameterTypes2[1].equals(String.class)) continue;
                    if (this.methods.getOnText() != null) {
                        throw new TioWebsocketException("duplicate TIOnText");
                    }
                    this.methods.setOnText(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (method.isAnnotationPresent(TIOnBytes.class)) {
                    returnType2 = method.getReturnType();
                    if (!returnType2.equals(Void.TYPE) || (parameterTypes2 = method.getParameterTypes()).length != 2 || !parameterTypes2[0].equals(ChannelContext.class) || !parameterTypes2[1].equals(byte[].class)) continue;
                    if (this.methods.getOnBytes() != null) {
                        throw new TioWebsocketException("duplicate TIOnBytes");
                    }
                    this.methods.setOnBytes(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                if (!method.isAnnotationPresent(TIOnMap.class)) continue;
                TIOnMap annotation = method.getAnnotation(TIOnMap.class);
                if (annotation.value().length() == 0) {
                    returnType = method.getReturnType();
                    if (!returnType.equals(Void.TYPE) || (parameterTypes = method.getParameterTypes()).length != 3 || !parameterTypes[0].equals(ChannelContext.class) || !parameterTypes[1].equals(String.class)) continue;
                    if (this.methods.getOnMap() != null) {
                        throw new TioWebsocketException("duplicate default TIOnMap");
                    }
                    this.methods.setOnMap(TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
                    continue;
                }
                returnType = method.getReturnType();
                if (!returnType.equals(Void.TYPE) || (parameterTypes = method.getParameterTypes()).length != 2 || !parameterTypes[0].equals(ChannelContext.class)) continue;
                if (this.methods.getOnMapEvent().get(annotation.value()) != null) {
                    throw new TioWebsocketException("duplicate TIOnMap with event " + annotation.value());
                }
                this.methods.getOnMapEvent().put(annotation.value(), TioWebsocketMethodMapper.builder().instance(bean).method(method).build());
            }
        });
        if (this.methods.getHandshake() == null) {
            throw new TioWebsocketException("miss @TIOnHandshake");
        }
        if (this.methods.getOnClose() == null) {
            throw new TioWebsocketException("miss @TIOnClose");
        }
        TioWebsocketMsgHandler handler = (TioWebsocketMsgHandler)this.starter.getWsMsgHandler();
        handler.setMethods(this.methods);
    }

    private void start() throws IOException {
        this.starter.start();
    }

    public ServerGroupContext getGroupContext() {
        return this.groupContext;
    }
}

