/*
 * Decompiled with CFR 0.152.
 */
package net.yushanginfo.erp.mes.wo.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import net.yushanginfo.erp.base.model.Factory;
import net.yushanginfo.erp.base.model.User;
import net.yushanginfo.erp.mes.model.AssessLog;
import net.yushanginfo.erp.mes.model.AssessRecord;
import net.yushanginfo.erp.mes.model.AssessStatus$;
import net.yushanginfo.erp.mes.model.SalesOrderType;
import net.yushanginfo.erp.mes.model.WorkOrder;
import net.yushanginfo.erp.mes.model.WorkOrderStatus;
import net.yushanginfo.erp.mes.model.WorkOrderType;
import net.yushanginfo.erp.mes.service.OrderService;
import net.yushanginfo.erp.mes.wo.helper.OrderImportHelper;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.excel.schema.ExcelColumn;
import org.beangle.data.excel.schema.ExcelScheet;
import org.beangle.data.excel.schema.ExcelSchema;
import org.beangle.data.model.Entity;
import org.beangle.data.transfer.importer.ImportListener;
import org.beangle.data.transfer.importer.ImportSetting;
import org.beangle.data.transfer.importer.listener.ForeignerListener;
import org.beangle.ems.app.Ems$;
import org.beangle.security.Securities$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.annotation.response;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.view.Stream$;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.support.action.RestfulAction;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class WorkOrderAction
extends RestfulAction<WorkOrder> {
    private OrderService orderService;

    public OrderService orderService() {
        return this.orderService;
    }

    public void orderService_$eq(OrderService x$1) {
        this.orderService = x$1;
    }

    public void indexSetting() {
        this.put("workOrderTypes", (Object)this.entityDao().getAll(WorkOrderType.class));
        this.put("workOrderStatuses", (Object)this.entityDao().getAll(WorkOrderStatus.class));
        this.put("factories", (Object)this.entityDao().getAll(Factory.class));
    }

    public void editSetting(WorkOrder entity) {
        this.put("salesOrderTypes", (Object)this.entityDao().getAll(SalesOrderType.class));
        this.put("workOrderTypes", (Object)this.entityDao().getAll(WorkOrderType.class));
        this.put("factories", (Object)this.entityDao().getAll(Factory.class));
        this.put("ems", (Object)Ems$.MODULE$);
        super.editSetting((Entity)entity);
    }

    public View saveAndRedirect(WorkOrder o) {
        if (o.createdAt() == null) {
            o.createdAt_$eq(Instant.now());
        }
        scala.collection.immutable.Seq users = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()})));
        this.orderService().recalcState(o, (User)users.head(), RequestUtils$.MODULE$.getIpAddr(ActionContext$.MODULE$.current().request()));
        return super.saveAndRedirect((Entity)o);
    }

    public View setPass() {
        List orderIds = this.longIds("workOrder");
        scala.collection.immutable.Seq orders = this.entityDao().find(WorkOrder.class, (Iterable)orderIds);
        orders.foreach((Function1)(JProcedure1 & Serializable)o -> {
            o.assessStatus_$eq(AssessStatus$.Passed);
            o.remark_$eq((Option)Some$.MODULE$.apply((Object)"\u624b\u52a8\u8bbe\u7f6e\u4e3a\u901a\u8fc7"));
        });
        this.entityDao().saveOrUpdate((Iterable)orders);
        return this.redirect("search", "info.save.success");
    }

    @response
    public Object downloadTemplate() {
        scala.collection.immutable.Seq workOrderStatuses = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(WorkOrderStatus.class, "p").orderBy("p.code")).map((Function1 & Serializable)_$2 -> _$2.name());
        scala.collection.immutable.Seq workOrderTypes = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(WorkOrderType.class, "p").orderBy("p.code")).map((Function1 & Serializable)_$3 -> _$3.name());
        scala.collection.immutable.Seq factories = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)OqlBuilder$.MODULE$.from(Factory.class, "p").orderBy("p.code")).map((Function1 & Serializable)_$4 -> _$4.name());
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u5de5\u5355\u4fe1\u606f\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u5fc5\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u987e\u5ba2\u4ee3\u7801", "workOrder.customer.code").length(5);
        excelColumn.required(excelColumn.required$default$1()).remark("\u22645\u4f4d");
        sheet.add("\u516c\u53f8\u56fe\u53f7", "workOrder.product.specification").length(100).remark("\u2264100\u4f4d");
        sheet.add("\u5de5\u5355\u72b6\u6001", "workOrder.status.code").ref((Seq)workOrderStatuses);
        ExcelColumn excelColumn2 = sheet.add("\u5ba2\u6237\u4ea4\u671f", "workOrder.deadline");
        ExcelColumn excelColumn3 = excelColumn2.date(excelColumn2.date$default$1());
        excelColumn3.required(excelColumn3.required$default$1());
        ExcelColumn excelColumn4 = sheet.add("\u5de5\u5355\u5355\u53f7", "workOrder.batchNum");
        excelColumn4.required(excelColumn4.required$default$1());
        ExcelColumn excelColumn5 = sheet.add("\u8ba1\u5212\u6570\u91cf", "workOrder.amount");
        excelColumn5.required(excelColumn5.required$default$1());
        ExcelColumn excelColumn6 = sheet.add("\u5de5\u5355\u5355\u522b", "workOrder.orderType.name");
        excelColumn6.required(excelColumn6.required$default$1()).ref((Seq)workOrderTypes);
        ExcelColumn excelColumn7 = sheet.add("\u5382\u533a", "workOrder.factory.name");
        excelColumn7.required(excelColumn7.required$default$1()).ref((Seq)factories);
        sheet.add("\u5de5\u827a\u8def\u7ebf\u7f16\u53f7", "technicScheme.indexno").remark("\u9ed8\u8ba4\u4e3a\u7f16\u53f7\u4e2d\u7684\u7b2c\u4e00\u4e2a");
        ExcelScheet code = schema.createScheet("\u6570\u636e\u5b57\u5178");
        code.add("\u5de5\u5355\u72b6\u6001").data((Seq)workOrderStatuses);
        code.add("\u5de5\u5355\u5355\u522b").data((Seq)workOrderTypes);
        code.add("\u5382\u533a\u4fe1\u606f").data((Seq)factories);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "\u5de5\u5355\u6a21\u677f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public void configImport(ImportSetting setting) {
        ForeignerListener fl = new ForeignerListener(this.entityDao());
        fl.addForeigerKey("code");
        fl.addForeigerKey("name");
        fl.addForeigerKey("specification");
        setting.listeners_$eq((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ImportListener[]{fl, new OrderImportHelper(this.entityDao())})));
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        WorkOrder order = (WorkOrder)this.entityDao().get(WorkOrder.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        OqlBuilder logQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(AssessLog.class, "al").where("al.orderId=:orderId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{order.id()}));
        logQuery.orderBy("al.updatedAt");
        scala.collection.immutable.Seq logs = this.entityDao().search((QueryBuilder)logQuery);
        this.put("logs", (Object)logs);
        this.put("workOrder", (Object)order);
        OqlBuilder recQuery = OqlBuilder$.MODULE$.from(AssessRecord.class, "r");
        recQuery.where("r.order=:order", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{order}));
        recQuery.orderBy("r.updatedAt");
        this.put("assessRecords", (Object)this.entityDao().search((QueryBuilder)recQuery));
        return this.forward(this.forward$default$1());
    }
}

