/*
 * Decompiled with CFR 0.152.
 */
package net.yushanginfo.erp.mes.wo.action;

import java.io.Serializable;
import java.time.Instant;
import net.yushanginfo.erp.base.model.User;
import net.yushanginfo.erp.mes.model.AssessLog;
import net.yushanginfo.erp.mes.model.AssessRecord;
import net.yushanginfo.erp.mes.model.AssessStatus;
import net.yushanginfo.erp.mes.model.AssessStatus$;
import net.yushanginfo.erp.mes.model.ReviewEvent;
import net.yushanginfo.erp.mes.model.Reviewer;
import net.yushanginfo.erp.mes.model.WorkOrder;
import net.yushanginfo.erp.mes.model.WorkOrderStatus;
import net.yushanginfo.erp.mes.model.WorkOrderType;
import net.yushanginfo.erp.mes.service.OrderService;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.LongId;
import org.beangle.ems.app.Ems$;
import org.beangle.security.Securities$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.view.View;
import org.beangle.web.servlet.util.RequestUtils$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.support.helper.QueryHelper$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SaleAssessAction
extends RestfulAction<WorkOrder> {
    private OrderService orderService;

    public OrderService orderService() {
        return this.orderService;
    }

    public void orderService_$eq(OrderService x$1) {
        this.orderService = x$1;
    }

    public void indexSetting() {
        this.put("orderTypes", this.entityDao().getAll(WorkOrderType.class));
        this.put("orderStatuses", this.entityDao().getAll(WorkOrderStatus.class));
    }

    /*
     * WARNING - void declaration
     */
    public OqlBuilder<WorkOrder> getQueryBuilder() {
        void var1_1;
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.get("customerCode").foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (Strings$.MODULE$.isNotEmpty((CharSequence)a)) {
                IntRef i = IntRef.create((int)0);
                String str = Strings$.MODULE$.replace(a, "\uff0c", ",");
                str = Strings$.MODULE$.replace(str, ";", ",");
                Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(str, ","));
                Object[] codeQueryStr = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)b -> {
                    int n;
                    i$1.elem = n = i$1.elem + 1;
                    query.param("customerCode" + i$1.elem, (Object)(b + "%"));
                    return "workOrder.product.specification like :customerCode" + i$1.elem;
                }, ClassTag$.MODULE$.apply(String.class));
                query.where(Predef$.MODULE$.wrapRefArray(codeQueryStr).mkString(" or "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        });
        QueryHelper$.MODULE$.dateBetween(query, null, "createdAt", "createdOn", "createdOn");
        this.getInt("reviewRound").foreach((Function1 & Serializable)round -> SaleAssessAction.getQueryBuilder$$anonfun$2(query, BoxesRunTime.unboxToInt((Object)round)));
        return var1_1;
    }

    public View review() {
        long id = this.longId("workOrder");
        WorkOrder order = (WorkOrder)this.entityDao().get(WorkOrder.class, (Object)BoxesRunTime.boxToLong((long)id));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Reviewer.class.getName(), "r");
        query.where(":factory in elements (r.factories)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{order.factory()}));
        query.where(":roundIdx in elements (r.rounds)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(order.reviewEvents().size() + 1))}));
        query.select("distinct r.user");
        this.put("watchers", this.entityDao().search((QueryBuilder)query));
        this.put("workOrder", order);
        this.put("ems", Ems$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    public View accept() {
        View view;
        long id = this.longId("workOrder");
        WorkOrder order = (WorkOrder)this.entityDao().get(WorkOrder.class, (Object)BoxesRunTime.boxToLong((long)id));
        Seq users = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()})));
        AssessStatus assessStatus = order.assessStatus();
        AssessStatus assessStatus2 = AssessStatus$.Unpassed;
        if (!(assessStatus != null ? !assessStatus.equals(assessStatus2) : assessStatus2 != null)) {
            order.assessStatus_$eq(AssessStatus$.Passed);
            order.remark_$eq((Option)Some$.MODULE$.apply((Object)"\u4e1a\u52a1\u63a5\u53d7\u8bc4\u5ba1\u4ea4\u671f\uff0c\u76f4\u63a5\u901a\u8fc7"));
            AssessLog log = new AssessLog(AssessStatus$.Unpassed, order, (User)users.head(), RequestUtils$.MODULE$.getIpAddr(ActionContext$.MODULE$.current().request()));
            this.entityDao().saveOrUpdate((Object)log, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new LongId[]{order}));
            view = this.redirect("search", "info.action.success");
        } else {
            view = this.redirect("search", order.assessStatus().name() + " \u4e2d\u7684\u5de5\u5355\u4e0d\u80fd\u76f4\u63a5\u901a\u8fc7");
        }
        return view;
    }

    public View issueReview() {
        long id = this.longId("workOrder");
        WorkOrder order = (WorkOrder)this.entityDao().get(WorkOrder.class, (Object)BoxesRunTime.boxToLong((long)id));
        Seq users = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()})));
        ReviewEvent event = (ReviewEvent)this.populateEntity(ReviewEvent.class, "reviewEvent");
        event.workOrder_$eq(order);
        event.issueBy_$eq((User)users.head());
        event.updatedAt_$eq(Instant.now());
        List watcherIds = this.longIds("watcher");
        if (watcherIds.nonEmpty()) {
            event.watchers().$plus$plus$eq((IterableOnce)this.entityDao().find(User.class, (Iterable)watcherIds));
        }
        this.orderService().issueReview(order, event, (User)users.head(), RequestUtils$.MODULE$.getIpAddr(ActionContext$.MODULE$.current().request()));
        this.entityDao().saveOrUpdate((Object)event, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new LongId[]{order}));
        return this.redirect("search", "info.save.success");
    }

    public View cancel() {
        List ids = this.longIds("workOrder");
        Seq workOrders = this.entityDao().find(WorkOrder.class, (Iterable)ids);
        workOrders.foreach((Function1)(JProcedure1 & Serializable)workOrder -> {
            workOrder.assessStatus_$eq(AssessStatus$.Cancel);
            this.get("remark").foreach((Function1)(JProcedure1 & Serializable)remark -> workOrder.remark_$eq(Option$.MODULE$.apply(remark)));
        });
        this.entityDao().saveOrUpdate((Iterable)workOrders);
        return this.redirect("search", "info.save.success");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        WorkOrder order = (WorkOrder)this.entityDao().get(WorkOrder.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        OqlBuilder logQuery = (OqlBuilder)OqlBuilder$.MODULE$.from(AssessLog.class, "al").where("al.orderId=:orderId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{order.id()}));
        logQuery.orderBy("al.updatedAt");
        Seq logs = this.entityDao().search((QueryBuilder)logQuery);
        this.put("logs", logs);
        this.put("workOrder", order);
        OqlBuilder recQuery = OqlBuilder$.MODULE$.from(AssessRecord.class, "r");
        recQuery.where("r.order=:order", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{order}));
        recQuery.orderBy("r.updatedAt");
        this.put("assessRecords", this.entityDao().search((QueryBuilder)recQuery));
        return this.forward(this.forward$default$1());
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder query$3, int round) {
        return (OqlBuilder)query$3.where("size(workOrder.reviewEvents) = :round", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)round)}));
    }
}

