/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public class Url {
    private String protocol;
    private String host;
    private int port;
    private String path;
    private String query;

    public Url(String spec) {
        this.protocol = Url.searchPart(spec, 0, ":");
        int startIdx = this.protocol.length() + 3;
        String hostPort = Url.searchPart(spec, startIdx, "/?");
        this.host = Url.searchPart(hostPort, 0, ":");
        String portStr = Url.searchPart(hostPort, this.host.length() + 1, "");
        if (portStr.length() > 0) {
            this.port = Integer.parseInt(portStr);
        }
        if ((startIdx += hostPort.length() + 1) < spec.length() && spec.charAt(startIdx - 1) == '?') {
            this.path = "";
            this.query = spec.substring(startIdx);
        } else {
            this.path = Url.searchPart(spec, startIdx, "?");
            this.query = Url.searchPart(spec, startIdx += this.path.length() + 1, "");
        }
    }

    public Url(String protocol, String host, int port, String file, String query) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = file;
        this.query = query;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String file) {
        this.path = file;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addQueryParameter(String key, String value) {
        if (this.query.length() > 0) {
            this.query = this.query + '&';
        }
        this.query = this.query + key + '=' + Url.encode(value);
    }

    public String getQueryParameter(String key) {
        String v;
        for (int startIdx = 0; startIdx < this.query.length(); startIdx += v.length() + 1) {
            String k = Url.searchPart(this.query, startIdx, "=");
            v = Url.searchPart(this.query, startIdx += k.length() + 1, "&");
            if (!key.equals(k)) continue;
            return Url.decode(v);
        }
        return "";
    }

    public String getPathSegment(int idx) {
        String res = "";
        int startIdx = 0;
        for (int i = 0; i <= idx; ++i) {
            res = Url.searchPart(this.path, startIdx, "/");
            startIdx += res.length() + 1;
        }
        return Url.decode(res);
    }

    public void addPathSegment(String newSeg) {
        if (this.path.length() > 0) {
            this.path = this.path + '/';
        }
        this.path = this.path + Url.encode(newSeg);
    }

    public String toString() {
        return this.protocol + "://" + this.host + (this.port > 0 ? ":" + this.port : "") + (this.path.length() > 0 ? "/" + this.path : "") + (this.query.length() > 0 ? "?" + this.query : "");
    }

    private static String searchPart(String spec, int startIdx, String delim) {
        if (startIdx >= spec.length()) {
            return "";
        }
        for (int i = 0; i < delim.length(); ++i) {
            int idx = spec.indexOf(delim.charAt(i), startIdx);
            if (idx < 0) continue;
            return spec.substring(startIdx, idx);
        }
        return spec.substring(startIdx);
    }

    public static Hashtable toHashtable(String query) {
        String v;
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int startIdx = 0; startIdx < query.length(); startIdx += v.length() + 1) {
            String k = Url.searchPart(query, startIdx, "=");
            v = Url.searchPart(query, startIdx += k.length() + 1, "&");
            map.put(Url.decode(k), Url.decode(v));
        }
        return map;
    }

    public static String toQueryString(Hashtable map) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(b);
            Url.writeQueryString(map, w);
            ((Writer)w).flush();
            return b.toString();
        }
        catch (IOException ex) {
            Logger.warn("error with " + map, ex);
            throw new RuntimeException(ex.toString());
        }
    }

    public static void writeQueryString(Hashtable params, Writer getpostb) throws IOException {
        Enumeration enu = params.keys();
        boolean first = true;
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            if (first) {
                first = false;
            } else {
                getpostb.write(38);
            }
            Url.encode(String.valueOf(key), getpostb);
            getpostb.write(61);
            Url.encode(String.valueOf(params.get(key)), getpostb);
        }
    }

    public static String encode(String s) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream(s.length());
            OutputStreamWriter w = new OutputStreamWriter(b);
            Url.encode(s, w);
            ((Writer)w).flush();
            return b.toString();
        }
        catch (IOException ex) {
            Logger.warn("error encoding " + s, ex);
            throw new RuntimeException(ex.toString());
        }
    }

    public static void encode(String s, Writer ret) throws IOException {
        for (int a = 0; a < s.length(); ++a) {
            byte[] ba;
            char c = s.charAt(a);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '*' || c == '_') {
                ret.write(c);
                continue;
            }
            if (c == ' ') {
                ret.write(43);
                continue;
            }
            if (StringUtil.isHighSurrogate(c) && a < s.length() - 1) {
                String charPair = s.substring(a, a + 2);
                ++a;
                ba = charPair.getBytes("UTF-8");
            } else {
                ba = String.valueOf(c).getBytes("UTF-8");
            }
            for (int j = 0; j < ba.length; ++j) {
                int n = ba[j] & 0xFF;
                ret.write(37);
                if (n < 16) {
                    ret.write(48);
                }
                ret.write(Integer.toHexString(n));
            }
        }
    }

    public static String decode(String s) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block8: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block8;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        try {
                            sb.append(new String(bytes, 0, pos, "UTF-8"));
                        }
                        catch (Exception ex) {
                            throw new RuntimeException();
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block8;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

