/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public abstract class CSVUtil {
    public char separator = (char)44;

    public abstract void newLine();

    public abstract void newValue(int var1, String var2);

    public abstract String getValueAt(Object var1, int var2);

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader inputStreamTxt) throws IOException {
        boolean inside = false;
        int how = 0;
        int count = 0;
        StringBuffer buf = new StringBuffer();
        this.newLine();
        try {
            int c;
            while ((c = inputStreamTxt.read()) != -1) {
                if (c == 13) continue;
                if (!inside) {
                    if (c == 34) {
                        inside = true;
                        how = (char)c;
                        if (buf.length() <= 0) continue;
                        buf.append((char)c);
                        continue;
                    }
                    if (c == 10) {
                        this.newValue(count, buf.toString().trim());
                        buf = new StringBuffer();
                        count = 0;
                        this.newLine();
                        continue;
                    }
                    if (c == this.separator) {
                        this.newValue(count, buf.toString().trim());
                        buf = new StringBuffer();
                        ++count;
                        continue;
                    }
                    buf.append((char)c);
                    continue;
                }
                if (c == how) {
                    inside = false;
                    continue;
                }
                buf.append((char)c);
            }
        }
        finally {
            try {
                if (inputStreamTxt != null) {
                    inputStreamTxt.close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
        }
    }

    public void store(OutputStream out, Vector objects, int count) throws IOException {
        this.store(new OutputStreamWriter(out), objects, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Writer writer, Vector objects, int count) throws IOException {
        try {
            for (int a = 0; a < objects.size(); ++a) {
                Object obj = objects.elementAt(a);
                StringBuffer buffer = new StringBuffer();
                for (int c = 0; c < count; ++c) {
                    String newString = this.getValueAt(obj, c);
                    if (newString != null && newString.indexOf(34) >= 0) {
                        newString = StringUtil.replaceAll(newString, "\"", "''");
                    }
                    if (newString != null && (newString.indexOf(44) >= 0 || newString.indexOf(10) >= 0)) {
                        buffer.append("\"");
                        buffer.append(newString);
                        buffer.append("\"");
                    } else if (newString != null) {
                        buffer.append(newString);
                    }
                    if (c >= count - 1) continue;
                    buffer.append(",");
                }
                writer.write(buffer.toString());
                writer.write("\n");
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Logger.info(null, ex);
            }
        }
    }
}

