package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

/**
 * @author Yura Mamyrin
 */
public abstract class CSVUtil {

	public char separator = ',';

	// new Object
	public abstract void newLine();

	// set value on object
	public abstract void newValue(int count,String value);

	public abstract String getValueAt(Object obj, int c);

	public void load(InputStream inputStream) throws IOException {
		load(new InputStreamReader(inputStream));
	}

	// i took something when i wrote this, it was shiny and a powder
	// makes for some crazy code, but at least it works
	public void load(Reader inputStreamTxt) throws IOException {

		boolean inside=false;
		char how=0;
		int count=0;
		StringBuffer buf = new StringBuffer();
		newLine();

		try {
			int c;
			while ((c = inputStreamTxt.read()) != -1) {
                                if (c=='\r') { continue; }

				if (!inside) {

					if (c=='"') { //  || c=='\''

						inside = true;
						how = (char)c;

						// quotes are escaped as 2 quotes inside a quoted string
						if (buf.length() > 0) {
							buf.append((char)c);
						}
					}
					else if (c=='\n') {

						// ignore the \r char
						//if ( !"\r".equals(buf.toString()) ) { // buf.length()>0 &&
                                                newValue(count,buf.toString().trim());
                                                buf = new StringBuffer();
						//}

						count = 0;

						newLine();

					}
					else if (c==separator) {

						//if (buf.length()>0) {
							newValue(count,buf.toString().trim());
							buf = new StringBuffer();
						//}

						count++;

					}
					else {

						// adding something that is not in quotes
						buf.append((char)c);
					}
				}
				else if (c==how) {
					inside = false;
                                        // not needed here, as will be added in 'outside' section anyway
					//saveDetail(product,count,buf.toString().trim());
					//buf = new StringBuffer();
				}
				else {
					// adding something that is in quotes
					buf.append((char)c);
				}


			}
		}
		//catch(Exception ex) {
			//Logger.warn(ex);
			//buf.append(ex.toString());
		//}
		finally {
			try { if (inputStreamTxt!=null) inputStreamTxt.close(); }
			catch(IOException ex) { Logger.info(null, ex); }
		}
	}

	public void store(OutputStream out, Vector objects,int count) throws IOException {
		store(new OutputStreamWriter(out), objects, count);
	}

	public void store(Writer writer, Vector objects,int count) throws IOException {

            try {

		for (int a=0;a<objects.size();a++) {
                        Object obj = objects.elementAt(a);

                        StringBuffer buffer = new StringBuffer();

                        for (int c=0;c<count;c++) {

                                String newString=getValueAt(obj,c);

                                if (newString!=null && newString.indexOf('"')>=0) {

                                        //throw new Exception("illegal char found: \"");
                                        // just strip out all the "
                                        newString = StringUtil.replaceAll(newString, "\"", "''");
                                }

                                if (newString!=null && (newString.indexOf(',')>=0 || newString.indexOf('\n')>=0)) {

                                        buffer.append("\"");

                                        buffer.append(newString);

                                        buffer.append("\"");

                                }
                                else if (newString!=null) {

                                        buffer.append(newString);

                                }

                                if (c<(count-1)) {
                                    buffer.append(",");
                                }
                        }

			writer.write( buffer.toString() );
			writer.write( "\n" );
                }
            }
            finally {
                try { if (writer!=null) writer.close(); }
                catch(IOException ex) { Logger.info(null, ex); }
	    }
	}
}
