/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.scaffold;

import freemarker.template.Configuration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.lang.PairObject;
import net.ymate.platform.core.support.ConsoleTableBuilder;
import net.ymate.platform.core.support.FreemarkerConfigBuilder;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.scaffold.Attr;
import net.ymate.platform.persistence.jdbc.scaffold.ColumnInfo;
import net.ymate.platform.persistence.jdbc.scaffold.ConfigInfo;
import net.ymate.platform.persistence.jdbc.scaffold.TableInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityGenerator {
    private static final Log _LOG = LogFactory.getLog(EntityGenerator.class);
    private final String __templateRootPath = EntityGenerator.class.getPackage().getName().replace(".", "/");
    private Configuration __freemarkerConfig;
    private IDatabase __owner;
    private ConfigInfo __config;
    private boolean __markdown;
    private boolean __csv;
    private boolean __onlyShow;

    private EntityGenerator() {
        try {
            this.__freemarkerConfig = FreemarkerConfigBuilder.create().addTemplateClass(EntityGenerator.class, "/").build();
        }
        catch (IOException e) {
            _LOG.error((Object)e.getMessage(), RuntimeUtils.unwrapThrow((Throwable)e));
        }
    }

    public EntityGenerator(YMP owner) {
        this();
        this.__owner = JDBC.get(owner == null ? YMP.get() : owner);
        this.__config = new ConfigInfo(this.__owner.getOwner());
    }

    public EntityGenerator markdown() {
        this.__markdown = true;
        return this;
    }

    public EntityGenerator csv() {
        this.__csv = true;
        return this;
    }

    public EntityGenerator onlyShow() {
        this.__onlyShow = true;
        return this;
    }

    public void createEntityClassFiles(boolean view) throws Exception {
        List<String> _tables = this.__config.getTableList();
        if (_tables.isEmpty()) {
            _tables = view ? TableInfo.getViewNames(this.__owner) : TableInfo.getTableNames(this.__owner);
        }
        for (String _tableName : _tables) {
            if (!this.checkTableNameBlacklist(_tableName)) continue;
            this.buildEntityClassFile(TableInfo.create(this.__owner.getDefaultConnectionHolder(), this.__config, _tableName, view), _tableName, view);
        }
    }

    private boolean checkTableNameBlacklist(String tableName) {
        if (!this.__config.getTableExcludeList().isEmpty()) {
            if (this.__config.getTableExcludeList().contains(tableName.toLowerCase())) {
                return false;
            }
            boolean _flag = false;
            for (String _excludedName : this.__config.getTableExcludeList()) {
                if (!StringUtils.contains((String)_excludedName, (String)"*") || !StringUtils.startsWithIgnoreCase((String)tableName, (String)StringUtils.substringBefore((String)_excludedName, (String)"*"))) continue;
                _flag = true;
                break;
            }
            if (_flag) {
                return false;
            }
        }
        return true;
    }

    private void buildEntityClassFile(TableInfo tableInfo, String _tableName, boolean view) {
        if (tableInfo != null) {
            ArrayList<Attr> _primaryKeyList;
            Map<String, Object> _properties = this.__config.toMap();
            if (this.__config.isUseBaseEntity()) {
                this.buildTargetFile("/model/BaseEntity.java", "/BaseEntity.ftl", _properties);
            }
            PairObject<String, String> _fixedName = this.__config.buildNamePrefix(_tableName);
            _properties.put("modelName", _fixedName.getKey());
            _properties.put("tableName", _fixedName.getValue());
            ArrayList<Attr> _fieldList = new ArrayList<Attr>();
            ArrayList _fieldListForNotNullable = new ArrayList();
            ArrayList<Attr> _allFieldList = new ArrayList<Attr>();
            if (tableInfo.getPkSet().size() > 1) {
                Attr _attr;
                ColumnInfo _ci;
                _properties.put("primaryKeyType", (String)_fixedName.getKey() + "PK");
                _properties.put("primaryKeyName", StringUtils.uncapitalize((String)((String)_properties.get("primaryKeyType"))));
                _primaryKeyList = new ArrayList<Attr>();
                _properties.put("primaryKeyList", _primaryKeyList);
                Attr _pkAttr = new Attr((String)_properties.get("primaryKeyType"), (String)_properties.get("primaryKeyName"), null, false, false, 0, 0, false, null, null);
                _fieldList.add(_pkAttr);
                _fieldListForNotNullable.add(_pkAttr);
                for (String pkey : tableInfo.getPkSet()) {
                    _ci = tableInfo.getFieldMap().get(pkey);
                    _attr = _ci.toAttr();
                    if (this.__config.getReadonlyFields().contains(_attr.getColumnName().toLowerCase())) {
                        _attr.setReadonly(true);
                    }
                    _primaryKeyList.add(_attr);
                    _allFieldList.add(new Attr("String", this.__config.namedFilter(_ci.getColumnName()).toUpperCase(), _ci.getColumnName(), _ci.isAutoIncrement(), _ci.isSigned(), _ci.getPrecision(), _ci.getScale(), _ci.isNullable(), _ci.getDefaultValue(), _ci.getRemarks()));
                }
                for (String key : tableInfo.getFieldMap().keySet()) {
                    if (tableInfo.getPkSet().contains(key)) continue;
                    _ci = tableInfo.getFieldMap().get(key);
                    _attr = _ci.toAttr();
                    if (this.__config.getReadonlyFields().contains(_attr.getColumnName().toLowerCase())) {
                        _attr.setReadonly(true);
                    }
                    _fieldList.add(_attr);
                    _fieldListForNotNullable.add(_attr);
                    _allFieldList.add(new Attr("String", this.__config.namedFilter(_ci.getColumnName()).toUpperCase(), _ci.getColumnName(), _ci.isAutoIncrement(), _ci.isSigned(), _ci.getPrecision(), _ci.getScale(), _ci.isNullable(), _ci.getDefaultValue(), _ci.getRemarks()));
                }
            } else {
                if (!view) {
                    _properties.put("primaryKeyType", tableInfo.getFieldMap().get(tableInfo.getPkSet().get(0)).getColumnType());
                    _properties.put("primaryKeyName", StringUtils.uncapitalize((String)EntityMeta.propertyNameToFieldName((String)tableInfo.getPkSet().get(0))));
                } else {
                    ColumnInfo _tmpCI = tableInfo.getFieldMap().get("id");
                    _properties.put("primaryKeyType", _tmpCI == null ? "Serializable" : _tmpCI.getColumnType());
                    _properties.put("primaryKeyName", "id");
                }
                for (String key : tableInfo.getFieldMap().keySet()) {
                    ColumnInfo _ci = tableInfo.getFieldMap().get(key);
                    Attr _attr = _ci.toAttr();
                    if (this.__config.getReadonlyFields().contains(_attr.getColumnName().toLowerCase())) {
                        _attr.setReadonly(true);
                    }
                    _fieldList.add(_attr);
                    if (!_attr.isNullable()) {
                        _fieldListForNotNullable.add(_attr);
                    }
                    _allFieldList.add(new Attr("String", this.__config.namedFilter(_ci.getColumnName()).toUpperCase(), _ci.getColumnName(), _ci.isAutoIncrement(), _ci.isSigned(), _ci.getPrecision(), _ci.getScale(), _ci.isNullable(), _ci.getDefaultValue(), _ci.getRemarks()));
                }
            }
            _properties.put("fieldList", _fieldList);
            _properties.put("notNullableFieldList", _fieldList.size() == _fieldListForNotNullable.size() ? Collections.emptyList() : _fieldListForNotNullable);
            _properties.put("allFieldList", _allFieldList);
            this.buildTargetFile("/model/" + (String)_fixedName.getKey() + (this.__config.isUseClassSuffix() ? "Model.java" : ".java"), view ? "/View.ftl" : "/Entity.ftl", _properties);
            if (!view && tableInfo.getPkSet().size() > 1) {
                _properties.put("modelName", _fixedName.getKey());
                if (tableInfo.getPkSet().size() > 1) {
                    _primaryKeyList = new ArrayList();
                    _properties.put("primaryKeyList", _primaryKeyList);
                    for (String pkey : tableInfo.getPkSet()) {
                        ColumnInfo _ci = tableInfo.getFieldMap().get(pkey);
                        _primaryKeyList.add(_ci.toAttr());
                    }
                }
                this.buildTargetFile("/model/" + (String)_fixedName.getKey() + "PK.java", "/EntityPK.ftl", _properties);
            }
            ConsoleTableBuilder _console = ConsoleTableBuilder.create((int)10).escape();
            System.out.println((view ? "VIEW" : "TABLE") + "_NAME: " + _tableName);
            System.out.println("MODEL_NAME: " + (String)_fixedName.getKey());
            if (this.__markdown) {
                _console.markdown();
                System.out.println();
            } else if (this.__csv) {
                _console.csv();
            }
            _console.addRow().addColumn("COLUMN_NAME").addColumn("COLUMN_CLASS_NAME").addColumn("PRIMARY_KEY").addColumn("AUTO_INCREMENT").addColumn("SIGNED").addColumn("PRECISION").addColumn("SCALE").addColumn("NULLABLE").addColumn("DEFAULT").addColumn("REMARKS");
            for (ColumnInfo _c : tableInfo.getFieldMap().values()) {
                _console.addRow().addColumn(_c.getColumnName()).addColumn(_c.getColumnType()).addColumn(_c.isPrimaryKey() ? "TRUE" : "FALSE").addColumn(_c.isAutoIncrement() ? "TRUE" : "FALSE").addColumn(_c.isSigned() ? "TRUE" : "FALSE").addColumn(_c.getPrecision() + "").addColumn(_c.getScale() + "").addColumn(_c.isNullable() ? "TRUE" : "FALSE").addColumn(_c.getDefaultValue()).addColumn(_c.getRemarks());
            }
            System.out.println(_console.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTargetFile(String targetFileName, String tmplFile, Map<String, Object> properties) {
        if (!this.__onlyShow) {
            BufferedWriter _outWriter = null;
            try {
                File _outputFile = new File(this.__config.getOutputPath(), new File(this.__config.getPackageName().replace('.', '/'), targetFileName).getPath());
                File _path = _outputFile.getParentFile();
                if (_path.exists() || _path.mkdirs()) {
                    _outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(_outputFile), StringUtils.defaultIfEmpty((String)this.__freemarkerConfig.getOutputEncoding(), (String)this.__freemarkerConfig.getDefaultEncoding())));
                    this.__freemarkerConfig.getTemplate(this.__templateRootPath + tmplFile).process(properties, (Writer)_outWriter);
                    System.out.println("Output file " + _outputFile);
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
            }
            finally {
                IOUtils.closeQuietly(_outWriter);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        YMP.get().init();
        try {
            new EntityGenerator(YMP.get()).createEntityClassFiles(args != null && args.length > 0 && BlurObject.bind((Object)args[0]).toBooleanValue());
        }
        finally {
            YMP.get().destroy();
        }
    }
}

