/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.scaffold;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.jdbc.scaffold.Attr;
import net.ymate.platform.persistence.jdbc.scaffold.ConfigInfo;
import net.ymate.platform.persistence.jdbc.scaffold.IEntityNamedFilter;
import org.apache.commons.lang.StringUtils;

public class ColumnInfo {
    private String name;
    private final String columnName;
    private final String columnType;
    private final boolean autoIncrement;
    private final boolean primaryKey;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final boolean nullable;
    private final String defaultValue;
    private final String remarks;

    public static Map<String, ColumnInfo> create(ConfigInfo configInfo, String dbType, String tableName, List<String> primaryKeys, DatabaseMetaData databaseMetaData, ResultSetMetaData metaData) throws SQLException {
        LinkedHashMap<String, ColumnInfo> _returnValue = new LinkedHashMap<String, ColumnInfo>(metaData.getColumnCount());
        for (int _idx = 1; _idx <= metaData.getColumnCount(); ++_idx) {
            ResultSet _column = databaseMetaData.getColumns(configInfo.getDbName(), "oracle".equalsIgnoreCase(dbType) ? configInfo.getDbUserName().toUpperCase() : configInfo.getDbUserName(), tableName, metaData.getColumnName(_idx));
            if (_column.next()) {
                String _name = metaData.getColumnName(_idx).toLowerCase();
                ColumnInfo _columnInfo = new ColumnInfo(configInfo.getNamedFilter(), _name, metaData.getColumnClassName(_idx), metaData.isAutoIncrement(_idx), primaryKeys.contains(_name), metaData.isSigned(_idx), metaData.getPrecision(_idx), metaData.getScale(_idx), metaData.isNullable(_idx), _column.getString("COLUMN_DEF"), _column.getString("REMARKS"));
                _returnValue.put(_name, _columnInfo);
            }
            _column.close();
        }
        return _returnValue;
    }

    public ColumnInfo(IEntityNamedFilter namedFilter, String columnName, String columnType, boolean autoIncrement, boolean primaryKey, boolean signed, int precision, int scale, int nullable, String defaultValue, String remarks) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.autoIncrement = autoIncrement;
        this.primaryKey = primaryKey;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable > 0;
        this.defaultValue = defaultValue;
        this.remarks = StringUtils.replaceEach((String)remarks, (String[])new String[]{"\"", "\r\n", "\r", "\n", "\t"}, (String[])new String[]{"\\\"", "[\\r][\\n]", "[\\r]", "[\\n]", "[\\t]"});
        this.name = namedFilter != null ? StringUtils.defaultIfBlank((String)namedFilter.doFilter(columnName), (String)columnName) : columnName;
        this.name = StringUtils.uncapitalize((String)EntityMeta.propertyNameToFieldName((String)this.name.toLowerCase()));
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Attr toAttr() {
        return new Attr(this.getColumnType(), this.name, this.getColumnName(), this.isAutoIncrement(), this.isSigned(), this.getPrecision(), this.getScale(), this.isNullable(), this.getDefaultValue(), this.getRemarks());
    }
}

