/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IShardingable;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.ISession;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query<T> {
    private static final Log _LOG = LogFactory.getLog(Query.class);
    private String __tablePrefix;
    private IDialect __dialect;
    private IShardingable __shardingable;

    public T set(ISession session) {
        return this.set(session.getConnectionHolder());
    }

    public T set(IConnectionHolder connectionHolder) {
        this.__tablePrefix = connectionHolder.getDataSourceCfgMeta().getTablePrefix();
        this.__dialect = connectionHolder.getDialect();
        return (T)this;
    }

    public String tablePrefix() {
        if (StringUtils.isBlank((String)this.__tablePrefix)) {
            ISession _session = null;
            try {
                _session = JDBC.get().openSession();
                if (_session != null) {
                    this.__tablePrefix = _session.getConnectionHolder().getDataSourceCfgMeta().getTablePrefix();
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
            }
            finally {
                if (_session != null) {
                    _session.close();
                }
            }
        }
        return this.__tablePrefix;
    }

    public T tablePrefix(String tablePrefix) {
        this.__tablePrefix = tablePrefix;
        return (T)this;
    }

    public IDialect dialect() {
        if (this.__dialect == null) {
            ISession _session = null;
            try {
                _session = JDBC.get().openSession();
                if (_session != null) {
                    this.__dialect = _session.getConnectionHolder().getDialect();
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
            }
            finally {
                if (_session != null) {
                    _session.close();
                }
            }
        }
        return this.__dialect;
    }

    public T dialect(IDialect dialect) {
        this.__dialect = dialect;
        return (T)this;
    }

    public IShardingable shardingable() {
        return this.__shardingable;
    }

    public T shardingable(IShardingable shardingable) {
        this.__shardingable = shardingable;
        return (T)this;
    }

    protected Fields __checkFieldExcluded(Fields fields) {
        if (fields.isExcluded()) {
            _LOG.warn((Object)"Query fields do not support exclusion and have been cleaned up.");
            return Fields.create((String[])new String[0]);
        }
        return fields;
    }

    protected String __buildSafeTableName(String prefix, String tableName, boolean safePrefix) {
        if (safePrefix) {
            prefix = StringUtils.defaultIfBlank((String)prefix, (String)this.tablePrefix());
            return this.dialect().wrapIdentifierQuote(StringUtils.trimToEmpty((String)prefix).concat(tableName));
        }
        return StringUtils.trimToEmpty((String)prefix).concat(tableName);
    }

    protected String __buildSafeTableName(String prefix, EntityMeta entityMeta, boolean safePrefix) {
        if (safePrefix) {
            prefix = StringUtils.defaultIfBlank((String)prefix, (String)this.tablePrefix());
            return this.dialect().buildTableName(prefix, entityMeta, this.shardingable());
        }
        return StringUtils.trimToEmpty((String)prefix).concat(entityMeta.getEntityName());
    }

    protected Fields __wrapIdentifierFields(String ... fields) {
        Fields _returnValue = Fields.create((String[])new String[0]);
        if (fields != null) {
            for (String _field : fields) {
                _returnValue.add(this.__wrapIdentifierField(_field));
            }
        }
        return _returnValue;
    }

    protected String __wrapIdentifierField(String field) {
        String[] _split = StringUtils.split((String)field, (String)".");
        if (_split != null && _split.length == 2) {
            String[] _alias = StringUtils.split((String)_split[1]);
            if (_alias != null && _alias.length == 2) {
                return _split[0] + "." + this.dialect().wrapIdentifierQuote(_alias[0]) + " " + _alias[1];
            }
            return _split[0] + "." + this.dialect().wrapIdentifierQuote(_split[1]);
        }
        return this.dialect().wrapIdentifierQuote(field);
    }

    public static String wrapIdentifierField(IConnectionHolder connectionHolder, String field) {
        String[] _split = StringUtils.split((String)field, (String)".");
        if (_split != null && _split.length == 2) {
            String[] _alias = StringUtils.split((String)_split[1]);
            if (_alias != null && _alias.length == 2) {
                return _split[0] + "." + connectionHolder.getDialect().wrapIdentifierQuote(_alias[0]) + " " + _alias[1];
            }
            return _split[0] + "." + connectionHolder.getDialect().wrapIdentifierQuote(_split[1]);
        }
        return connectionHolder.getDialect().wrapIdentifierQuote(field);
    }
}

