/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

import java.util.Collection;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.query.Query;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.query.Select;
import org.apache.commons.lang.StringUtils;

public final class Insert
extends Query<Insert> {
    private final String __prefix;
    private String __tableName;
    private Class<? extends IEntity> __entityClass;
    private final Fields __fields;
    private final Params __params;
    private Select __select;
    private final boolean __safePrefix;

    public static Insert create(String prefix, Class<? extends IEntity> entityClass) {
        return new Insert(prefix, entityClass);
    }

    public static Insert create(IEntity<?> entity) {
        return Insert.create(entity.getClass());
    }

    public static Insert create(Class<? extends IEntity> entityClass) {
        return new Insert(null, entityClass);
    }

    public static Insert create(String tableName) {
        return new Insert(null, tableName, true);
    }

    public static Insert create(String tableName, boolean safePrefix) {
        return new Insert(null, tableName, safePrefix);
    }

    private Insert(String prefix, Class<? extends IEntity> entityClass) {
        this.__prefix = prefix;
        this.__entityClass = entityClass;
        this.__safePrefix = true;
        this.__fields = Fields.create((String[])new String[0]);
        this.__params = Params.create((Object[])new Object[0]);
    }

    private Insert(String prefix, String tableName, boolean safePrefix) {
        this.__prefix = prefix;
        this.__tableName = tableName;
        this.__safePrefix = safePrefix;
        this.__fields = Fields.create((String[])new String[0]);
        this.__params = Params.create((Object[])new Object[0]);
    }

    public Fields fields() {
        return this.__fields;
    }

    public Insert field(String prefix, String field, String alias) {
        return this.field(prefix, field, alias, true);
    }

    public Insert field(String prefix, String field, String alias, boolean wrapIdentifier) {
        this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(field) : field, alias);
        return this;
    }

    public Insert field(String prefix, String field) {
        return this.field(prefix, field, true);
    }

    public Insert field(String prefix, String field, boolean wrapIdentifier) {
        this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(field) : field);
        return this;
    }

    public Insert field(String field) {
        return this.field(field, true);
    }

    public Insert field(String field, boolean wrapIdentifier) {
        this.__fields.add(wrapIdentifier ? this.__wrapIdentifierField(field) : field);
        return this;
    }

    public Insert field(Fields fields) {
        return this.field(fields, true);
    }

    public Insert field(Fields fields, boolean wrapIdentifier) {
        Fields _field = this.__checkFieldExcluded(fields);
        this.__fields.add(wrapIdentifier ? this.__wrapIdentifierFields(_field.toArray()) : _field);
        return this;
    }

    public Insert field(String prefix, Fields fields) {
        return this.field(prefix, fields, true);
    }

    public Insert field(String prefix, Fields fields, boolean wrapIdentifier) {
        for (String _field : this.__checkFieldExcluded(fields).fields()) {
            this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(_field) : _field);
        }
        return this;
    }

    public Params params() {
        return this.__params;
    }

    public Insert param(Object param) {
        this.__params.add(param);
        return this;
    }

    public Insert param(Params params) {
        this.__params.add(params);
        return this;
    }

    public Insert select(Select select) {
        this.__select = select;
        return this;
    }

    public String toString() {
        String _sqlStr = "INSERT INTO ".concat(this.__safePrefix ? (this.__entityClass != null ? this.__buildSafeTableName(this.__prefix, EntityMeta.createAndGet(this.__entityClass), this.__safePrefix) : this.__buildSafeTableName(this.__prefix, this.__tableName, true)) : this.__tableName).concat(" (").concat(StringUtils.join((Collection)this.__fields.fields(), (String)", "));
        if (this.__select != null) {
            return _sqlStr.concat(") ").concat(this.__select.toString());
        }
        return _sqlStr.concat(") VALUES (").concat(StringUtils.repeat((String)"?", (String)", ", (int)this.__params.params().size())).concat(")");
    }

    public SQL toSQL() {
        return SQL.create(this);
    }
}

