/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.ymate.platform.core.util.ResourceUtils;
import net.ymate.platform.persistence.jdbc.AbstractDataSourceAdapter;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCPDataSourceAdapter
extends AbstractDataSourceAdapter {
    private static final Log _LOG = LogFactory.getLog(DBCPDataSourceAdapter.class);
    private BasicDataSource __ds;

    @Override
    protected void __doInit() throws Exception {
        Properties _props = new Properties();
        InputStream _in = ResourceUtils.getResourceAsStream((String)("dbcp_" + this.__cfgMeta.getName() + ".properties"), this.getClass());
        if (_in == null) {
            _in = ResourceUtils.getResourceAsStream((String)"dbcp.properties", this.getClass());
        }
        try {
            if (_in != null) {
                _props.load(_in);
            }
            _props.put("driverClassName", this.__cfgMeta.getDriverClass());
            _props.put("url", this.__cfgMeta.getConnectionUrl());
            _props.put("username", this.__cfgMeta.getUsername());
            _props.put("password", this.__doGetPasswordDecryptIfNeed());
            this.__ds = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)_props);
        }
        finally {
            IOUtils.closeQuietly((InputStream)_in);
        }
    }

    @Override
    public void destroy() {
        if (this.__ds != null) {
            try {
                this.__ds.close();
            }
            catch (SQLException e) {
                _LOG.warn((Object)"", (Throwable)e);
            }
        }
        super.destroy();
    }

    @Override
    public Connection getConnection() throws Exception {
        return this.__ds.getConnection();
    }
}

